/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandMessageFormatting;
import org.spongepowered.api.command.CommandNotFoundException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.ImmutableCommandMapping;
import org.spongepowered.api.command.dispatcher.Disambiguator;
import org.spongepowered.api.command.dispatcher.Dispatcher;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;

final class SpongeCommandDispatcher
implements Dispatcher {
    private static final BiPredicate<CommandSource, CommandMapping> ON_EXECUTE = (source, mapping) -> {
        if (SpongeImpl.getGlobalConfigAdapter().getConfig().getCommands().getCommandHiding().isHideDuringExecution()) {
            return mapping.getCallable().testPermission((CommandSource)source);
        }
        return true;
    };
    static final BiPredicate<CommandSource, CommandMapping> ON_DISCOVERY = (source, mapping) -> {
        if (SpongeImpl.getGlobalConfigAdapter().getConfig().getCommands().getCommandHiding().isHideDuringDiscovery()) {
            return mapping.getCallable().testPermission((CommandSource)source);
        }
        return true;
    };
    static final Disambiguator FIRST_DISAMBIGUATOR = (source, aliasUsed, availableOptions) -> {
        for (CommandMapping mapping : availableOptions) {
            if (!mapping.getPrimaryAlias().toLowerCase().equals(aliasUsed.toLowerCase())) continue;
            return Optional.of(mapping);
        }
        return Optional.of(availableOptions.get(0));
    };
    private final Disambiguator disambiguatorFunc;
    private final ListMultimap<String, CommandMapping> commands = ArrayListMultimap.create();

    public SpongeCommandDispatcher(Disambiguator disambiguatorFunc) {
        this.disambiguatorFunc = disambiguatorFunc;
    }

    public Optional<CommandMapping> register(CommandCallable callable, String ... alias) {
        Preconditions.checkNotNull((Object)alias, (Object)"alias");
        return this.register(callable, Arrays.asList(alias));
    }

    public Optional<CommandMapping> register(CommandCallable callable, List<String> aliases) {
        return this.register(callable, aliases, Function.identity());
    }

    public synchronized Optional<CommandMapping> register(CommandCallable callable, List<String> aliases, Function<List<String>, List<String>> callback) {
        Preconditions.checkNotNull(aliases, (Object)"aliases");
        Preconditions.checkNotNull((Object)callable, (Object)"callable");
        Preconditions.checkNotNull(callback, (Object)"callback");
        aliases = ImmutableList.copyOf((Collection)callback.apply((List<String>)aliases));
        if (aliases.isEmpty()) {
            return Optional.empty();
        }
        String primary = (String)aliases.get(0);
        List<String> secondary = aliases.subList(1, aliases.size());
        ImmutableCommandMapping mapping = new ImmutableCommandMapping(callable, primary, secondary);
        for (String alias : aliases) {
            this.commands.put((Object)alias.toLowerCase(), (Object)mapping);
        }
        return Optional.of(mapping);
    }

    public synchronized Collection<CommandMapping> remove(String alias) {
        return this.commands.removeAll((Object)alias.toLowerCase());
    }

    public synchronized boolean removeAll(Collection<?> aliases) {
        Preconditions.checkNotNull(aliases, (Object)"aliases");
        boolean found = false;
        for (Object alias : aliases) {
            if (this.commands.removeAll((Object)alias.toString().toLowerCase()).isEmpty()) continue;
            found = true;
        }
        return found;
    }

    public synchronized Optional<CommandMapping> removeMapping(CommandMapping mapping) {
        Preconditions.checkNotNull((Object)mapping, (Object)"mapping");
        CommandMapping found = null;
        Iterator it = this.commands.values().iterator();
        while (it.hasNext()) {
            CommandMapping current = (CommandMapping)it.next();
            if (!current.equals(mapping)) continue;
            it.remove();
            found = current;
        }
        return Optional.ofNullable(found);
    }

    public synchronized boolean removeMappings(Collection<?> mappings) {
        Preconditions.checkNotNull(mappings, (Object)"mappings");
        boolean found = false;
        Iterator it = this.commands.values().iterator();
        while (it.hasNext()) {
            if (!mappings.contains(it.next())) continue;
            it.remove();
            found = true;
        }
        return found;
    }

    public synchronized Set<CommandMapping> getCommands() {
        return ImmutableSet.copyOf((Collection)this.commands.values());
    }

    @Override
    public synchronized Set<String> getPrimaryAliases() {
        HashSet<String> aliases = new HashSet<String>();
        for (CommandMapping mapping : this.commands.values()) {
            aliases.add(mapping.getPrimaryAlias());
        }
        return Collections.unmodifiableSet(aliases);
    }

    @Override
    public synchronized Set<String> getAliases() {
        HashSet<String> aliases = new HashSet<String>();
        for (CommandMapping mapping : this.commands.values()) {
            aliases.addAll(mapping.getAllAliases());
        }
        return Collections.unmodifiableSet(aliases);
    }

    public Optional<CommandMapping> get(String alias) {
        return this.get(alias, null);
    }

    public synchronized Optional<CommandMapping> get(String alias, @Nullable CommandSource source) {
        return this.get(alias, source, (src, mapping) -> mapping.getCallable().testPermission((CommandSource)src));
    }

    public synchronized Optional<CommandMapping> get(String alias, @Nullable CommandSource source, BiPredicate<CommandSource, CommandMapping> filter) {
        List results = this.commands.get((Object)alias.toLowerCase());
        Optional<Object> result = Optional.empty();
        if (results.size() == 1) {
            result = Optional.of(results.get(0));
        } else if (results.size() > 1) {
            result = this.disambiguatorFunc.disambiguate(source, alias, results);
        }
        return result.filter(x -> source == null || filter.test(source, (CommandMapping)x));
    }

    @Override
    public synchronized boolean containsAlias(String alias) {
        return this.commands.containsKey((Object)alias.toLowerCase());
    }

    @Override
    public boolean containsMapping(CommandMapping mapping) {
        Preconditions.checkNotNull((Object)mapping, (Object)"mapping");
        for (CommandMapping test : this.commands.values()) {
            if (!mapping.equals(test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CommandResult process(CommandSource source, String commandLine) throws CommandException {
        String[] argSplit = commandLine.split(" ", 2);
        Optional<CommandMapping> cmdOptional = this.get(argSplit[0], source, ON_EXECUTE);
        if (!cmdOptional.isPresent()) {
            throw new CommandNotFoundException(SpongeApiTranslationHelper.t("commands.generic.notFound", new Object[0]), argSplit[0]);
        }
        String arguments = argSplit.length > 1 ? argSplit[1] : "";
        CommandMapping mapping = cmdOptional.get();
        Optional<PluginContainer> pluginOwner = Sponge.getCommandManager().getOwner(mapping);
        pluginOwner.ifPresent(pluginContainer -> Sponge.getCauseStackManager().pushCause(pluginContainer));
        CommandCallable spec = mapping.getCallable();
        Sponge.getCauseStackManager().pushCause(spec);
        try {
            CommandResult commandResult = spec.process(source, arguments);
            return commandResult;
        }
        catch (CommandNotFoundException e) {
            throw new CommandException(SpongeApiTranslationHelper.t("No such child command: %s", e.getCommand()));
        }
        finally {
            if (pluginOwner.isPresent()) {
                Sponge.getCauseStackManager().popCause();
            }
            Sponge.getCauseStackManager().popCause();
        }
    }

    @Override
    public List<String> getSuggestions(CommandSource src, String arguments, @Nullable Location<World> targetPosition) throws CommandException {
        String[] argSplit = arguments.split(" ", 2);
        Optional<CommandMapping> cmdOptional = this.get(argSplit[0], src, ON_DISCOVERY);
        if (argSplit.length == 1) {
            return (List)this.filterCommands(src, argSplit[0]).stream().collect(ImmutableList.toImmutableList());
        }
        if (!cmdOptional.isPresent()) {
            return ImmutableList.of();
        }
        return cmdOptional.get().getCallable().getSuggestions(src, argSplit[1], targetPosition);
    }

    @Override
    public boolean testPermission(CommandSource source) {
        for (CommandMapping mapping : this.commands.values()) {
            if (!mapping.getCallable().testPermission(source)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.empty();
    }

    @Override
    public Optional<Text> getHelp(CommandSource source) {
        if (this.commands.isEmpty()) {
            return Optional.empty();
        }
        Text.Builder build = SpongeApiTranslationHelper.t("Available commands:\n", new Object[0]).toBuilder();
        Iterator<String> it = this.filterCommands(source).iterator();
        while (it.hasNext()) {
            Optional<CommandMapping> mappingOpt = this.get(it.next(), source);
            if (!mappingOpt.isPresent()) continue;
            CommandMapping mapping = mappingOpt.get();
            Optional<Text> description = mapping.getCallable().getShortDescription(source);
            build.append(((LiteralText.Builder)Text.builder(mapping.getPrimaryAlias()).color(TextColors.GREEN).style(TextStyles.UNDERLINE).onClick((ClickAction)TextActions.suggestCommand("/" + mapping.getPrimaryAlias()))).build(), CommandMessageFormatting.SPACE_TEXT, description.orElse(mapping.getCallable().getUsage(source)));
            if (!it.hasNext()) continue;
            build.append(Text.NEW_LINE);
        }
        return Optional.of(build.build());
    }

    private Set<String> filterCommands(CommandSource src) {
        return Multimaps.filterValues(this.commands, input -> input.getCallable().testPermission(src)).keys().elementSet();
    }

    private Set<String> filterCommands(CommandSource src, String start) {
        ListMultimap map = Multimaps.filterKeys(this.commands, input -> input != null && input.toLowerCase().startsWith(start.toLowerCase()));
        return Multimaps.filterValues((Multimap)map, input -> input.getCallable().testPermission(src)).keys().elementSet();
    }

    public synchronized int size() {
        return this.commands.size();
    }

    @Override
    public Text getUsage(CommandSource source) {
        Text.Builder build = Text.builder();
        Iterable filteredCommands = this.filterCommands(source).stream().filter(input -> {
            if (input == null) {
                return false;
            }
            Optional<CommandMapping> ret = this.get((String)input, source);
            return ret.isPresent() && ret.get().getPrimaryAlias().equals(input);
        }).collect(Collectors.toList());
        Iterator it = filteredCommands.iterator();
        while (it.hasNext()) {
            build.append(Text.of((String)it.next()));
            if (!it.hasNext()) continue;
            build.append(CommandMessageFormatting.PIPE_TEXT);
        }
        return build.build();
    }

    public synchronized Set<CommandMapping> getAll(String alias) {
        return ImmutableSet.copyOf((Collection)this.commands.get((Object)alias));
    }

    @Override
    public Multimap<String, CommandMapping> getAll() {
        return ImmutableMultimap.copyOf(this.commands);
    }
}

