/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import com.google.common.reflect.TypeToken;
import java.util.function.Predicate;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.util.TypeTokens;
import org.spongepowered.common.config.CatalogTypeTypeSerializer;
import org.spongepowered.common.data.persistence.ConfigurateTranslator;

public class DataSerializableTypeSerializer
implements TypeSerializer<DataSerializable> {
    public static final DataSerializableTypeSerializer INSTANCE = new DataSerializableTypeSerializer();
    public static final TypeToken<DataSerializable> TYPE = TypeToken.of(DataSerializable.class);

    private DataSerializableTypeSerializer() {
    }

    public static Predicate<TypeToken<DataSerializable>> predicate() {
        return x -> TYPE.isSupertypeOf(x) && !CatalogTypeTypeSerializer.TYPE.isSupertypeOf(x) && !TypeTokens.TEXT_TOKEN.isSupertypeOf(x);
    }

    @Override
    public DataSerializable deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        Class clazz = type.getRawType();
        if (clazz.isAssignableFrom(CatalogType.class)) {
            return (DataSerializable)CatalogTypeTypeSerializer.INSTANCE.deserialize((TypeToken)type, value);
        }
        return Sponge.getDataManager().deserialize(clazz.asSubclass(DataSerializable.class), ConfigurateTranslator.instance().translate(value)).orElseThrow(() -> new ObjectMappingException("Could not translate DataSerializable of type: " + clazz.getName()));
    }

    @Override
    public void serialize(TypeToken<?> type, DataSerializable obj, ConfigurationNode value) throws ObjectMappingException {
        if (obj instanceof CatalogType) {
            CatalogTypeTypeSerializer.INSTANCE.serialize(type, (CatalogType)((Object)obj), value);
        } else {
            ConfigurateTranslator.instance().translateDataToNode(value, obj.toContainer());
        }
    }
}

