/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import java.util.HashMap;
import java.util.Map;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.common.config.category.ConfigCategory;

@ConfigSerializable
public class BlockTrackerModCategory
extends ConfigCategory {
    @Setting(value="enabled", comment="If 'false', all tracking for this mod will be ignored.")
    private boolean isEnabled = true;
    @Setting(value="block-bulk-capture", comment="Set to true to perform block bulk capturing during block ticks. (Default: true)")
    private Map<String, Boolean> blockBulkCaptureMap = new HashMap<String, Boolean>();
    @Setting(value="entity-bulk-capture", comment="Set to true to perform entity bulk capturing during block ticks. (Default: true)")
    private Map<String, Boolean> entityBulkCaptureMap = new HashMap<String, Boolean>();
    @Setting(value="block-event-creation", comment="Set to true to create and fire block events during block ticks. (Default: true)")
    private Map<String, Boolean> blockEventCreationMap = new HashMap<String, Boolean>();
    @Setting(value="entity-block-creation", comment="Set to true to create and fire entity events during block ticks. (Default: true)")
    private Map<String, Boolean> entityEventCreationMap = new HashMap<String, Boolean>();

    public BlockTrackerModCategory() {
    }

    public BlockTrackerModCategory(String modId) {
        if (modId.equals("minecraft")) {
            // empty if block
        }
        if (modId.equals("extrautils2")) {
            this.blockBulkCaptureMap.put("redstoneclock", false);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Map<String, Boolean> getBlockBulkCaptureMap() {
        return this.blockBulkCaptureMap;
    }

    public Map<String, Boolean> getEntityBulkCaptureMap() {
        return this.entityBulkCaptureMap;
    }

    public Map<String, Boolean> getBlockEventCreationMap() {
        return this.blockEventCreationMap;
    }

    public Map<String, Boolean> getEntityEventCreationMap() {
        return this.entityEventCreationMap;
    }
}

