/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.config.category.ConfigCategory;
import org.spongepowered.common.data.persistence.SerializedDataTransaction;

@ConfigSerializable
public class CustomDataRegistrationCategory
extends ConfigCategory {
    @Setting(value="registered-data", comment="An auto generated list, by Sponge, to provide a list of\nregistered custom data manipulators by plugins. Since\nthe list is generated AFTER the game starts, modifying\nthis list will not affect Sponge's system in any way.\nHowever, it is advisable to view what registered datas\nexist on a server instance, such that when Sponge completes\nstartup, it will be verified that all existing registrations\nare accounted for. A warning will be emitted for any existing\nregistrations that were not registered, and moved to the\n'failed-data-list'.")
    private Set<String> registeredDataIds = new ConcurrentSkipListSet<String>();
    @Setting(value="failed-data-list", comment="An auto generated list, by Sponge, to discover and list\nall failed custom data deserializations at runtime due\nto a lack of the registrations being made by a plugin.\nNot to be confused by failed deserialization due to bad data.\nModifying the list will result in no effect as Sponge auto\ngenerates this list. This is merely for user configuration.")
    private Set<String> discoveredFailedDatas = new ConcurrentSkipListSet<String>();
    @Setting(value="data-to-purge", comment="A configurable list of registration ids that are to be removed\nwhen discovered for deserialization. This can be controlled by\ncommands in sponge. It is adviseable to refer to the lists made\navailable through 'failed-data-list', as using any id's from\n'registered-data' will result in custom data being deleted at\nevery load.")
    private Set<String> purgeDatas = new ConcurrentSkipListSet<String>();
    @Setting(value="print-on-discovery", comment="In the cases where there is already previously discovered data\nwe don't want to spam the log on each discovery in certain\ncontexts. If it is required, we still can emit the log warning\nwhen necessary.")
    private boolean printFailedDataOnDiscovery = false;

    public void populateRegistrations(Collection<DataRegistration<?, ?>> registrations) {
        this.registeredDataIds.clear();
        for (DataRegistration<?, ?> registration : registrations) {
            this.registeredDataIds.add(registration.getId());
        }
    }

    public void addFailedData(String dataId, Throwable cause) {
        if (this.discoveredFailedDatas.add(dataId) && this.printFailedDataOnDiscovery) {
            new PrettyPrinter(60).add("Failed Data Discovery").centre().hr().addWrapped("Sponge found an unregistered DataRegistration id. Don't worry though!Sponge will attempt to persist the failed data for future attempts, unlessthe id is added in 'data-to-purge' in the sponge/custom-data.cnf", new Object[0]).add().add("%s : %s", "Unregistered Id", dataId).add(new InvalidDataException("Could not deserialize " + dataId + "!", cause)).trace();
        }
    }

    public void purgeOrAllow(SerializedDataTransaction.Builder builder, String dataId, DataView view) {
        if (!this.purgeDatas.contains(dataId)) {
            builder.failedData(view);
        }
    }
}

