/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.util.Tristate;

@ConfigSerializable
public class MetricsCategory {
    @Setting(value="global-state", comment="The global collection state that should be respected by all plugins that have no specified collection state. If 'undefined' then it is treated as disabled.")
    private Tristate globalState = Tristate.UNDEFINED;
    @Setting(value="plugin-states", comment="Plugin-specific collection states that override the global collection state.")
    private final Map<String, Tristate> pluginStates = new HashMap<String, Tristate>();

    public Tristate getGlobalCollectionState() {
        return this.globalState;
    }

    public Tristate getCollectionState(PluginContainer container) {
        return this.pluginStates.getOrDefault(container.getId(), Tristate.UNDEFINED);
    }

    public Map<String, Tristate> getCollectionStates() {
        return Collections.unmodifiableMap(this.pluginStates);
    }
}

