/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.manipulator;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.data.util.DataFunction;
import org.spongepowered.common.data.util.DataProcessorDelegate;

public final class SpongeDataManipulatorBuilder<T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>>
implements DataManipulatorBuilder<T, I> {
    private final DataProcessorDelegate<T, I> delegate;
    private final Class<T> manipulatorClass;
    private final Constructor<T> constructor;
    private final DataFunction<DataContainer, T, Optional<T>> buildFunction;

    public SpongeDataManipulatorBuilder(DataProcessorDelegate<T, I> delegate, Class<T> manipulatorClass, DataFunction<DataContainer, T, Optional<T>> buildFunction) {
        this.delegate = (DataProcessorDelegate)Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(manipulatorClass);
        Preconditions.checkArgument((!Modifier.isAbstract(manipulatorClass.getModifiers()) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Modifier.isInterface(manipulatorClass.getModifiers()) ? 1 : 0) != 0);
        this.manipulatorClass = manipulatorClass;
        try {
            this.constructor = manipulatorClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No no-args constructor found for class: " + manipulatorClass.getCanonicalName(), e);
        }
        this.buildFunction = (DataFunction)Preconditions.checkNotNull(buildFunction);
    }

    @Override
    public Optional<T> createFrom(DataHolder dataHolder) {
        return this.delegate.createFrom(dataHolder);
    }

    @Override
    public T create() {
        try {
            return (T)((DataManipulator)this.constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("No no-args constructor found for class: " + this.manipulatorClass.getCanonicalName(), e);
        }
    }

    @Override
    public Optional<T> build(DataView container) throws InvalidDataException {
        DataContainer usedContainer = container instanceof DataContainer ? (DataContainer)container : container.copy();
        return this.buildFunction.apply(usedContainer, this.create());
    }
}

