/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.datasync.DataParameterConverter;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.mixin.core.entity.EntityAccessor;

public class EntityFlagsConverter
extends DataParameterConverter<Byte> {
    public static final int ON_FIRE_MASK = 1;
    public static final int CROUCHED_MASK = 2;
    public static final int UNUSED_MASK = 4;
    public static final int SPRINTING_MASK = 8;
    public static final int UNUSED_2_MASK = 16;
    public static final int INVISIBLE_MASK = 32;
    public static final int GLOWING_MASK = 64;
    public static final int FLYING_ELYTRA_MASK = 128;

    public EntityFlagsConverter() {
        super(EntityAccessor.accessor$getFlagsParameter());
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(Entity entity, Byte currentValue, Byte value) {
        boolean onFire = this.getFlag(currentValue, 1);
        boolean isSneaking = this.getFlag(currentValue, 2);
        boolean sprinting = this.getFlag(currentValue, 8);
        boolean invisible = this.getFlag(currentValue, 32);
        boolean glowing = this.getFlag(currentValue, 64);
        boolean elytra = this.getFlag(currentValue, 128);
        boolean newOnFire = this.getFlag(value, 1);
        boolean newIsSneaking = this.getFlag(value, 2);
        boolean newSprinting = this.getFlag(value, 8);
        boolean newInvisible = this.getFlag(value, 32);
        boolean newGlowing = this.getFlag(value, 64);
        boolean newElytra = this.getFlag(value, 128);
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        boolean changed = false;
        if (isSneaking != newIsSneaking) {
            builder.replace(ImmutableSpongeValue.cachedOf(Keys.IS_SNEAKING, false, isSneaking));
            builder.success(ImmutableSpongeValue.cachedOf(Keys.IS_SNEAKING, false, newIsSneaking));
            changed = true;
        }
        if (sprinting != newSprinting) {
            builder.replace(ImmutableSpongeValue.cachedOf(Keys.IS_SPRINTING, false, sprinting));
            builder.success(ImmutableSpongeValue.cachedOf(Keys.IS_SPRINTING, false, newSprinting));
            changed = true;
        }
        if (invisible != newInvisible) {
            builder.replace(ImmutableSpongeValue.cachedOf(Keys.INVISIBLE, false, invisible));
            builder.success(ImmutableSpongeValue.cachedOf(Keys.INVISIBLE, false, newInvisible));
            changed = true;
        }
        if (glowing != newGlowing) {
            builder.replace(ImmutableSpongeValue.cachedOf(Keys.GLOWING, false, glowing));
            builder.success(ImmutableSpongeValue.cachedOf(Keys.GLOWING, false, newGlowing));
            changed = true;
        }
        if (elytra != newElytra) {
            builder.replace(ImmutableSpongeValue.cachedOf(Keys.IS_ELYTRA_FLYING, false, elytra));
            builder.success(ImmutableSpongeValue.cachedOf(Keys.IS_ELYTRA_FLYING, false, newElytra));
            changed = true;
        }
        builder.result(DataTransactionResult.Type.SUCCESS);
        return changed ? Optional.of(builder.build()) : Optional.empty();
    }

    @Override
    public Byte getValueFromEvent(Byte originalValue, List<ImmutableValue<?>> immutableValues) {
        if (immutableValues.isEmpty()) {
            return originalValue;
        }
        boolean onFire = this.getFlag(originalValue, 1);
        boolean newIsSneaking = this.getFlag(originalValue, 2);
        boolean newSprinting = this.getFlag(originalValue, 8);
        boolean newInvisible = this.getFlag(originalValue, 32);
        boolean newGlowing = this.getFlag(originalValue, 64);
        boolean newElytra = this.getFlag(originalValue, 128);
        for (ImmutableValue<?> immutableValue : immutableValues) {
            if (immutableValue.getKey() == Keys.IS_SNEAKING) {
                newIsSneaking = (Boolean)immutableValue.get();
            }
            if (immutableValue.getKey() == Keys.IS_SPRINTING) {
                newSprinting = (Boolean)immutableValue.get();
            }
            if (immutableValue.getKey() == Keys.INVISIBLE) {
                newInvisible = (Boolean)immutableValue.get();
            }
            if (immutableValue.getKey() == Keys.GLOWING) {
                newGlowing = (Boolean)immutableValue.get();
            }
            if (immutableValue.getKey() != Keys.IS_ELYTRA_FLYING) continue;
            newElytra = (Boolean)immutableValue.get();
        }
        byte newValue = (byte)(onFire ? 1 : 0);
        newValue = (byte)(newIsSneaking ? newValue | 2 : newValue & 0xFFFFFFFD);
        newValue = (byte)(newSprinting ? newValue | 8 : newValue & 0xFFFFFFF7);
        newValue = (byte)(newInvisible ? newValue | 0x20 : newValue & 0xFFFFFFDF);
        newValue = (byte)(newGlowing ? newValue | 0x40 : newValue & 0xFFFFFFBF);
        newValue = (byte)(newElytra ? newValue | 0x80 : newValue & 0xFFFFFF7F);
        return newValue;
    }

    private boolean getFlag(byte value, int mask) {
        return (value & mask) != 0;
    }
}

