/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.datasync.DataParameterConverter;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.mixin.core.entity.EntityLivingAccessor;

public class EntityLivingAIFlagsConverter
extends DataParameterConverter<Byte> {
    public EntityLivingAIFlagsConverter() {
        super(EntityLivingAccessor.accessor$getAiFlagsParameter());
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(Entity entity, Byte currentValue, Byte value) {
        boolean oldHasAi = (currentValue & 1) == 0;
        boolean newHasAi = (value & 1) == 0;
        return Optional.of(DataTransactionResult.builder().replace(ImmutableSpongeValue.cachedOf(Keys.AI_ENABLED, true, oldHasAi)).success(ImmutableSpongeValue.cachedOf(Keys.AI_ENABLED, true, newHasAi)).result(DataTransactionResult.Type.SUCCESS).build());
    }

    @Override
    public Byte getValueFromEvent(Byte originalValue, List<ImmutableValue<?>> immutableValues) {
        for (ImmutableValue<?> immutableValue : immutableValues) {
            if (immutableValue.getKey() != Keys.AI_ENABLED) continue;
            Boolean hasAi = (Boolean)immutableValue.get();
            originalValue = hasAi != false ? (byte)(originalValue & 0xFFFFFFFE) : (byte)(originalValue | 1);
        }
        return originalValue;
    }
}

