/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import java.util.Collections;
import java.util.Set;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableDisabledSlotsData;
import org.spongepowered.api.data.manipulator.mutable.entity.DisabledSlotsData;
import org.spongepowered.api.data.value.immutable.ImmutableSetValue;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeDisabledSlotsData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeSetValue;

public class ImmutableSpongeDisabledSlotsData
extends AbstractImmutableData<ImmutableDisabledSlotsData, DisabledSlotsData>
implements ImmutableDisabledSlotsData {
    private Set<EquipmentType> takingDisabled;
    private Set<EquipmentType> placingDisabled;
    private ImmutableSetValue<EquipmentType> takingDisabledValue;
    private ImmutableSetValue<EquipmentType> placingDisabledValue;

    public ImmutableSpongeDisabledSlotsData() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public ImmutableSpongeDisabledSlotsData(Set<EquipmentType> takingDisabled, Set<EquipmentType> placingDisabled) {
        super(ImmutableDisabledSlotsData.class);
        this.takingDisabled = takingDisabled;
        this.placingDisabled = placingDisabled;
        this.takingDisabledValue = new ImmutableSpongeSetValue<EquipmentType>(Keys.ARMOR_STAND_TAKING_DISABLED, this.takingDisabled);
        this.placingDisabledValue = new ImmutableSpongeSetValue<EquipmentType>(Keys.ARMOR_STAND_PLACING_DISABLED, this.placingDisabled);
        this.registerGetters();
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.ARMOR_STAND_TAKING_DISABLED, () -> this.takingDisabled);
        this.registerKeyValue(Keys.ARMOR_STAND_TAKING_DISABLED, () -> this.takingDisabledValue);
        this.registerFieldGetter(Keys.ARMOR_STAND_PLACING_DISABLED, () -> this.placingDisabled);
        this.registerKeyValue(Keys.ARMOR_STAND_PLACING_DISABLED, () -> this.placingDisabledValue);
    }

    @Override
    public SpongeDisabledSlotsData asMutable() {
        return new SpongeDisabledSlotsData(this.takingDisabled, this.placingDisabled);
    }

    @Override
    public ImmutableSetValue<EquipmentType> takingDisabled() {
        return this.takingDisabledValue;
    }

    @Override
    public ImmutableSetValue<EquipmentType> placingDisabled() {
        return this.placingDisabledValue;
    }
}

