/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableExperienceHolderData;
import org.spongepowered.api.data.manipulator.mutable.entity.ExperienceHolderData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeExperienceHolderData;
import org.spongepowered.common.data.processor.common.ExperienceHolderUtils;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class ImmutableSpongeExperienceHolderData
extends AbstractImmutableData<ImmutableExperienceHolderData, ExperienceHolderData>
implements ImmutableExperienceHolderData {
    private final int level;
    private final int totalExp;
    private final int expSinceLevel;
    private final int expBetweenLevels;
    private final ImmutableBoundedValue<Integer> levelValue;
    private final ImmutableBoundedValue<Integer> totalExpValue;
    private final ImmutableBoundedValue<Integer> expSinceLevelValue;
    private final ImmutableBoundedValue<Integer> expBetweenLevelsValue;

    public ImmutableSpongeExperienceHolderData(int level, int totalExp, int expSinceLevel) {
        super(ImmutableExperienceHolderData.class);
        this.level = level;
        this.expBetweenLevels = ExperienceHolderUtils.getExpBetweenLevels(level);
        this.totalExp = totalExp;
        this.expSinceLevel = expSinceLevel;
        this.levelValue = SpongeValueFactory.boundedBuilder(Keys.EXPERIENCE_LEVEL).actualValue(this.level).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).build().asImmutable();
        this.totalExpValue = SpongeValueFactory.boundedBuilder(Keys.TOTAL_EXPERIENCE).actualValue(this.totalExp).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).build().asImmutable();
        this.expSinceLevelValue = SpongeValueFactory.boundedBuilder(Keys.EXPERIENCE_SINCE_LEVEL).actualValue(this.expSinceLevel).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).build().asImmutable();
        this.expBetweenLevelsValue = SpongeValueFactory.boundedBuilder(Keys.EXPERIENCE_FROM_START_OF_LEVEL).actualValue(this.expBetweenLevels).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).build().asImmutable();
        this.registerGetters();
    }

    @Override
    public ExperienceHolderData asMutable() {
        return new SpongeExperienceHolderData(this.level, this.totalExp, this.expSinceLevel);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.EXPERIENCE_LEVEL.getQuery(), (Object)this.level).set(Keys.TOTAL_EXPERIENCE.getQuery(), (Object)this.totalExp).set(Keys.EXPERIENCE_SINCE_LEVEL.getQuery(), (Object)this.expSinceLevel);
    }

    @Override
    public ImmutableBoundedValue<Integer> level() {
        return this.levelValue;
    }

    @Override
    public ImmutableBoundedValue<Integer> totalExperience() {
        return this.totalExpValue;
    }

    @Override
    public ImmutableBoundedValue<Integer> experienceSinceLevel() {
        return this.expSinceLevelValue;
    }

    @Override
    public ImmutableBoundedValue<Integer> experienceBetweenLevels() {
        return this.expBetweenLevelsValue;
    }

    public int getLevel() {
        return this.level;
    }

    public int getTotalExp() {
        return this.totalExp;
    }

    public int getExpSinceLevel() {
        return this.expSinceLevel;
    }

    public int getExpBetweenLevels() {
        return this.expBetweenLevels;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.EXPERIENCE_LEVEL, this::getLevel);
        this.registerKeyValue(Keys.EXPERIENCE_LEVEL, this::level);
        this.registerFieldGetter(Keys.TOTAL_EXPERIENCE, this::getTotalExp);
        this.registerKeyValue(Keys.TOTAL_EXPERIENCE, this::totalExperience);
        this.registerFieldGetter(Keys.EXPERIENCE_SINCE_LEVEL, this::getExpSinceLevel);
        this.registerKeyValue(Keys.EXPERIENCE_SINCE_LEVEL, this::experienceSinceLevel);
        this.registerFieldGetter(Keys.EXPERIENCE_FROM_START_OF_LEVEL, this::getExpBetweenLevels);
        this.registerKeyValue(Keys.EXPERIENCE_FROM_START_OF_LEVEL, this::experienceBetweenLevels);
    }
}

