/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFoodData;
import org.spongepowered.api.data.manipulator.mutable.entity.FoodData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeFoodData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class ImmutableSpongeFoodData
extends AbstractImmutableData<ImmutableFoodData, FoodData>
implements ImmutableFoodData {
    private final int foodLevel;
    private final double foodSaturationLevel;
    private final double foodExhaustionLevel;
    private final ImmutableBoundedValue<Integer> foodLevelValue;
    private final ImmutableBoundedValue<Double> saturationValue;
    private final ImmutableBoundedValue<Double> exhaustionValue;

    public ImmutableSpongeFoodData(int foodLevel, double foodSaturationLevel, double foodExhaustionLevel) {
        super(ImmutableFoodData.class);
        this.foodLevel = foodLevel;
        this.foodSaturationLevel = foodSaturationLevel;
        this.foodExhaustionLevel = foodExhaustionLevel;
        this.foodLevelValue = SpongeValueFactory.boundedBuilder(Keys.FOOD_LEVEL).defaultValue(20).minimum(0).maximum(Integer.MAX_VALUE).actualValue(this.foodLevel).build().asImmutable();
        this.exhaustionValue = SpongeValueFactory.boundedBuilder(Keys.EXHAUSTION).actualValue(this.foodExhaustionLevel).defaultValue(0.0).minimum(0.0).maximum((Double)Double.MAX_VALUE).build().asImmutable();
        this.saturationValue = SpongeValueFactory.boundedBuilder(Keys.SATURATION).actualValue(this.foodSaturationLevel).defaultValue(20.0).minimum(0.0).maximum((Double)Double.MAX_VALUE).build().asImmutable();
        this.registerGetters();
    }

    @Override
    public FoodData asMutable() {
        return new SpongeFoodData(this.foodLevel, this.foodSaturationLevel, this.foodExhaustionLevel);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.FOOD_LEVEL, (Object)this.foodLevel).set(Keys.SATURATION, (Object)this.foodSaturationLevel).set(Keys.EXHAUSTION, (Object)this.foodExhaustionLevel);
    }

    @Override
    public ImmutableBoundedValue<Integer> foodLevel() {
        return this.foodLevelValue;
    }

    @Override
    public ImmutableBoundedValue<Double> exhaustion() {
        return this.exhaustionValue;
    }

    @Override
    public ImmutableBoundedValue<Double> saturation() {
        return this.saturationValue;
    }

    public int getFood() {
        return this.foodLevel;
    }

    public double getExhaustion() {
        return this.foodExhaustionLevel;
    }

    public double getSaturation() {
        return this.foodSaturationLevel;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.FOOD_LEVEL, this::getFood);
        this.registerKeyValue(Keys.FOOD_LEVEL, this::foodLevel);
        this.registerFieldGetter(Keys.EXHAUSTION, this::getExhaustion);
        this.registerKeyValue(Keys.EXHAUSTION, this::exhaustion);
        this.registerFieldGetter(Keys.SATURATION, this::getSaturation);
        this.registerKeyValue(Keys.SATURATION, this::saturation);
    }
}

