/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableWireAttachmentData;
import org.spongepowered.api.data.manipulator.mutable.block.WireAttachmentData;
import org.spongepowered.api.data.type.WireAttachmentType;
import org.spongepowered.api.data.type.WireAttachmentTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeWireAttachmentData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeMapValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeWireAttachmentData
extends AbstractData<WireAttachmentData, ImmutableWireAttachmentData>
implements WireAttachmentData {
    private Map<Direction, WireAttachmentType> wireAttachmentMap;
    private static final Map<Direction, WireAttachmentType> DEFAULTS = ImmutableMap.of((Object)((Object)Direction.NORTH), (Object)WireAttachmentTypes.NONE, (Object)((Object)Direction.SOUTH), (Object)WireAttachmentTypes.NONE, (Object)((Object)Direction.EAST), (Object)WireAttachmentTypes.NONE, (Object)((Object)Direction.WEST), (Object)WireAttachmentTypes.NONE);

    public SpongeWireAttachmentData() {
        this(DEFAULTS);
    }

    public SpongeWireAttachmentData(Map<Direction, WireAttachmentType> attachmentMap) {
        super(WireAttachmentData.class);
        this.wireAttachmentMap = Maps.newHashMap(attachmentMap);
        this.registerGettersAndSetters();
    }

    @Override
    public MapValue<Direction, WireAttachmentType> wireAttachments() {
        return new SpongeMapValue<Direction, WireAttachmentType>((Key<BaseValue<Map<Direction, WireAttachmentType>>>)Keys.WIRE_ATTACHMENTS, Maps.newHashMap(this.wireAttachmentMap));
    }

    @Override
    public Value<WireAttachmentType> wireAttachmentNorth() {
        return new SpongeValue<WireAttachmentType>(Keys.WIRE_ATTACHMENT_NORTH, WireAttachmentTypes.NONE, this.wireAttachmentMap.get((Object)Direction.NORTH));
    }

    @Override
    public Value<WireAttachmentType> wireAttachmentSouth() {
        return new SpongeValue<WireAttachmentType>(Keys.WIRE_ATTACHMENT_SOUTH, WireAttachmentTypes.NONE, this.wireAttachmentMap.get((Object)Direction.SOUTH));
    }

    @Override
    public Value<WireAttachmentType> wireAttachmentEast() {
        return new SpongeValue<WireAttachmentType>(Keys.WIRE_ATTACHMENT_EAST, WireAttachmentTypes.NONE, this.wireAttachmentMap.get((Object)Direction.EAST));
    }

    @Override
    public Value<WireAttachmentType> wireAttachmentWest() {
        return new SpongeValue<WireAttachmentType>(Keys.WIRE_ATTACHMENT_WEST, WireAttachmentTypes.NONE, this.wireAttachmentMap.get((Object)Direction.WEST));
    }

    @Override
    public WireAttachmentData copy() {
        return new SpongeWireAttachmentData(this.wireAttachmentMap);
    }

    @Override
    public ImmutableWireAttachmentData asImmutable() {
        return new ImmutableSpongeWireAttachmentData(this.wireAttachmentMap);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.WIRE_ATTACHMENTS.getQuery(), this.wireAttachmentMap).set(Keys.WIRE_ATTACHMENT_NORTH.getQuery(), (Object)this.wireAttachmentMap.get((Object)Direction.NORTH).getId()).set(Keys.WIRE_ATTACHMENT_EAST.getQuery(), (Object)this.wireAttachmentMap.get((Object)Direction.EAST).getId()).set(Keys.WIRE_ATTACHMENT_SOUTH.getQuery(), (Object)this.wireAttachmentMap.get((Object)Direction.SOUTH).getId()).set(Keys.WIRE_ATTACHMENT_WEST.getQuery(), (Object)this.wireAttachmentMap.get((Object)Direction.WEST).getId());
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.WIRE_ATTACHMENT_NORTH, () -> this.wireAttachmentMap.get((Object)Direction.NORTH));
        this.registerFieldSetter(Keys.WIRE_ATTACHMENT_NORTH, x -> this.wireAttachmentMap.put(Direction.NORTH, (WireAttachmentType)x));
        this.registerKeyValue(Keys.WIRE_ATTACHMENT_NORTH, this::wireAttachmentNorth);
        this.registerFieldGetter(Keys.WIRE_ATTACHMENT_SOUTH, () -> this.wireAttachmentMap.get((Object)Direction.SOUTH));
        this.registerFieldSetter(Keys.WIRE_ATTACHMENT_SOUTH, x -> this.wireAttachmentMap.put(Direction.SOUTH, (WireAttachmentType)x));
        this.registerKeyValue(Keys.WIRE_ATTACHMENT_SOUTH, this::wireAttachmentSouth);
        this.registerFieldGetter(Keys.WIRE_ATTACHMENT_EAST, () -> this.wireAttachmentMap.get((Object)Direction.EAST));
        this.registerFieldSetter(Keys.WIRE_ATTACHMENT_EAST, x -> this.wireAttachmentMap.put(Direction.EAST, (WireAttachmentType)x));
        this.registerKeyValue(Keys.WIRE_ATTACHMENT_EAST, this::wireAttachmentEast);
        this.registerFieldGetter(Keys.WIRE_ATTACHMENT_WEST, () -> this.wireAttachmentMap.get((Object)Direction.WEST));
        this.registerFieldSetter(Keys.WIRE_ATTACHMENT_WEST, x -> this.wireAttachmentMap.put(Direction.WEST, (WireAttachmentType)x));
        this.registerKeyValue(Keys.WIRE_ATTACHMENT_WEST, this::wireAttachmentWest);
        this.registerFieldGetter(Keys.WIRE_ATTACHMENTS, () -> ImmutableMap.copyOf(this.wireAttachmentMap));
        this.registerFieldSetter(Keys.WIRE_ATTACHMENTS, x -> {
            this.wireAttachmentMap.put(Direction.NORTH, x.getOrDefault((Object)Direction.NORTH, WireAttachmentTypes.NONE));
            this.wireAttachmentMap.put(Direction.SOUTH, x.getOrDefault((Object)Direction.SOUTH, WireAttachmentTypes.NONE));
            this.wireAttachmentMap.put(Direction.EAST, x.getOrDefault((Object)Direction.EAST, WireAttachmentTypes.NONE));
            this.wireAttachmentMap.put(Direction.WEST, x.getOrDefault((Object)Direction.WEST, WireAttachmentTypes.NONE));
        });
        this.registerKeyValue(Keys.WIRE_ATTACHMENTS, this::wireAttachments);
    }
}

