/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.tileentity;

import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableBeaconData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.BeaconData;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.common.data.manipulator.immutable.tileentity.ImmutableSpongeBeaconData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeOptionalValue;

public class SpongeBeaconData
extends AbstractData<BeaconData, ImmutableBeaconData>
implements BeaconData {
    @Nullable
    private PotionEffectType primaryEffect;
    @Nullable
    private PotionEffectType secondaryEffect;

    public SpongeBeaconData() {
        this(null, null);
    }

    public SpongeBeaconData(@Nullable PotionEffectType primaryEffect, @Nullable PotionEffectType secondaryEffect) {
        super(BeaconData.class);
        this.primaryEffect = primaryEffect;
        this.secondaryEffect = secondaryEffect;
        this.registerGettersAndSetters();
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.BEACON_PRIMARY_EFFECT, this::getPrimaryEffect);
        this.registerFieldSetter(Keys.BEACON_PRIMARY_EFFECT, this::setPrimaryEffect);
        this.registerKeyValue(Keys.BEACON_PRIMARY_EFFECT, this::primaryEffect);
        this.registerFieldGetter(Keys.BEACON_SECONDARY_EFFECT, this::getSecondaryEffect);
        this.registerFieldSetter(Keys.BEACON_SECONDARY_EFFECT, this::setSecondaryEffect);
        this.registerKeyValue(Keys.BEACON_SECONDARY_EFFECT, this::secondaryEffect);
    }

    public Optional<PotionEffectType> getPrimaryEffect() {
        return Optional.ofNullable(this.primaryEffect);
    }

    public void setPrimaryEffect(Optional<PotionEffectType> primaryEffect) {
        this.primaryEffect = primaryEffect.orElse(null);
    }

    @Override
    public OptionalValue<PotionEffectType> primaryEffect() {
        return new SpongeOptionalValue<PotionEffectType>(Keys.BEACON_PRIMARY_EFFECT, Optional.ofNullable(this.primaryEffect));
    }

    public Optional<PotionEffectType> getSecondaryEffect() {
        return Optional.ofNullable(this.secondaryEffect);
    }

    public void setSecondaryEffect(Optional<PotionEffectType> secondaryEffect) {
        this.secondaryEffect = secondaryEffect.orElse(null);
    }

    @Override
    public OptionalValue<PotionEffectType> secondaryEffect() {
        return new SpongeOptionalValue<PotionEffectType>(Keys.BEACON_SECONDARY_EFFECT, Optional.ofNullable(this.secondaryEffect));
    }

    @Override
    public BeaconData clearEffects() {
        this.primaryEffect = null;
        this.secondaryEffect = null;
        return this;
    }

    @Override
    public BeaconData copy() {
        return new SpongeBeaconData(this.primaryEffect, this.secondaryEffect);
    }

    @Override
    public ImmutableBeaconData asImmutable() {
        return new ImmutableSpongeBeaconData(this.primaryEffect, this.secondaryEffect);
    }

    @Override
    public DataContainer toContainer() {
        DataContainer dataContainer = super.toContainer();
        if (this.primaryEffect != null) {
            dataContainer = dataContainer.set(Keys.BEACON_PRIMARY_EFFECT.getQuery(), (Object)this.primaryEffect.getId());
        }
        if (this.secondaryEffect != null) {
            dataContainer = dataContainer.set(Keys.BEACON_SECONDARY_EFFECT.getQuery(), (Object)this.secondaryEffect.getId());
        }
        return dataContainer;
    }
}

