/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.nbt;

import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFlyingData;
import org.spongepowered.api.data.manipulator.mutable.entity.FlyingData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeFlyingData;
import org.spongepowered.common.data.nbt.AbstractSpongeNbtProcessor;
import org.spongepowered.common.data.nbt.NbtDataTypes;
import org.spongepowered.common.data.nbt.data.NbtDataProcessor;

public class IsFlyingNbtProcessor
extends AbstractSpongeNbtProcessor<FlyingData, ImmutableFlyingData>
implements NbtDataProcessor<FlyingData, ImmutableFlyingData> {
    public IsFlyingNbtProcessor() {
        super(NbtDataTypes.ENTITY);
    }

    @Override
    public boolean isCompatible(NBTTagCompound nbtDataType) {
        return false;
    }

    @Override
    public Optional<FlyingData> readFrom(NBTTagCompound compound) {
        NBTBase tag = compound.func_74781_a("flying");
        if (tag != null) {
            return Optional.of(new SpongeFlyingData(((NBTTagByte)tag).func_150290_f() != 0));
        }
        return Optional.empty();
    }

    @Override
    public Optional<FlyingData> readFrom(DataView view) {
        return view.getBoolean(Keys.IS_FLYING.getQuery()).map(SpongeFlyingData::new);
    }

    @Override
    public Optional<NBTTagCompound> storeToCompound(NBTTagCompound compound, FlyingData manipulator) {
        compound.func_74757_a("flying", ((Boolean)manipulator.flying().get()).booleanValue());
        return Optional.of(compound);
    }

    @Override
    public Optional<DataView> storeToView(DataView view, FlyingData manipulator) {
        view.set(Keys.IS_FLYING, manipulator.flying().get());
        return Optional.of(view);
    }

    @Override
    public DataTransactionResult remove(NBTTagCompound data) {
        return null;
    }

    @Override
    public DataTransactionResult remove(DataView data) {
        return null;
    }
}

