/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import net.minecraft.entity.projectile.EntityFireball;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAccelerationData;
import org.spongepowered.api.data.manipulator.mutable.entity.AccelerationData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAccelerationData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.mixin.core.entity.projectile.EntityFireballAccessor;
import org.spongepowered.common.util.Constants;

public class AccelerationDataProcessor
extends AbstractEntitySingleDataProcessor<EntityFireball, Vector3d, Value<Vector3d>, AccelerationData, ImmutableAccelerationData> {
    public AccelerationDataProcessor() {
        super(EntityFireball.class, Keys.ACCELERATION);
    }

    @Override
    protected AccelerationData createManipulator() {
        return new SpongeAccelerationData();
    }

    @Override
    protected boolean set(EntityFireball fireball, Vector3d value) {
        ((EntityFireballAccessor)fireball).accessor$setAccelerationX(value.getX());
        ((EntityFireballAccessor)fireball).accessor$setAccelerationY(value.getY());
        ((EntityFireballAccessor)fireball).accessor$setAccelerationZ(value.getZ());
        return true;
    }

    @Override
    protected Optional<Vector3d> getVal(EntityFireball fireball) {
        return Optional.of(new Vector3d(fireball.field_70232_b, fireball.field_70233_c, fireball.field_70230_d));
    }

    @Override
    public Optional<AccelerationData> fill(DataContainer container, AccelerationData accelerationData) {
        DataUtil.checkDataExists(container, Keys.ACCELERATION.getQuery());
        DataView internalView = container.getView(Keys.ACCELERATION.getQuery()).get();
        double x = DataUtil.getData(internalView, Constants.Sponge.AccelerationData.ACCELERATION_X, Double.class);
        double y = DataUtil.getData(internalView, Constants.Sponge.AccelerationData.ACCELERATION_Y, Double.class);
        double z = DataUtil.getData(internalView, Constants.Sponge.AccelerationData.ACCELERATION_Z, Double.class);
        return Optional.of(accelerationData.set(Keys.ACCELERATION, new Vector3d(x, y, z)));
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected Value<Vector3d> constructValue(Vector3d actualValue) {
        return new SpongeValue<Vector3d>(Keys.ACCELERATION, Vector3d.ZERO, actualValue);
    }

    @Override
    protected ImmutableValue<Vector3d> constructImmutableValue(Vector3d value) {
        return new ImmutableSpongeValue<Vector3d>(Keys.ACCELERATION, Vector3d.ZERO, value);
    }
}

