/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.passive.EntityVillager;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableCareerData;
import org.spongepowered.api.data.manipulator.mutable.entity.CareerData;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.data.type.Careers;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.bridge.entity.EntityVillagerBridge;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeCareerData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class CareerDataProcessor
extends AbstractEntitySingleDataProcessor<EntityVillager, Career, Value<Career>, CareerData, ImmutableCareerData> {
    public CareerDataProcessor() {
        super(EntityVillager.class, Keys.CAREER);
    }

    @Override
    protected CareerData createManipulator() {
        return new SpongeCareerData();
    }

    @Override
    protected boolean set(EntityVillager entity, Career value) {
        ((EntityVillagerBridge)entity).bridge$setCareer(value);
        return true;
    }

    @Override
    protected Optional<Career> getVal(EntityVillager entity) {
        return Optional.of(((EntityVillagerBridge)entity).bridge$getCareer());
    }

    @Override
    protected ImmutableValue<Career> constructImmutableValue(Career value) {
        return ImmutableSpongeValue.cachedOf(Keys.CAREER, Careers.FARMER, value);
    }

    @Override
    protected Value<Career> constructValue(Career actualValue) {
        return new SpongeValue<Career>(Keys.CAREER, Careers.FARMER, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

