/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableTargetedEntityData;
import org.spongepowered.api.data.manipulator.mutable.entity.TargetedEntityData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeTargetedEntityData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.mixin.core.entity.projectile.ShulkerBulletEntityAccessor;

public final class EntityTargetedEntityDataProcessor
extends AbstractSingleDataSingleTargetProcessor<ShulkerBulletEntityAccessor, EntitySnapshot, Value<EntitySnapshot>, TargetedEntityData, ImmutableTargetedEntityData> {
    public EntityTargetedEntityDataProcessor() {
        super(Keys.TARGETED_ENTITY, ShulkerBulletEntityAccessor.class);
    }

    @Override
    protected boolean set(ShulkerBulletEntityAccessor dataHolder, EntitySnapshot value) {
        if (!value.getUniqueId().isPresent()) {
            return false;
        }
        Entity newTarget = ((WorldServer)((EntityShulkerBullet)dataHolder).field_70170_p).func_175733_a(value.getUniqueId().get());
        if (newTarget == null) {
            return false;
        }
        dataHolder.accessor$setTarget(newTarget);
        dataHolder.accessor$setTargetId(newTarget.func_110124_au());
        return true;
    }

    @Override
    protected Optional<EntitySnapshot> getVal(ShulkerBulletEntityAccessor dataHolder) {
        Entity entity = dataHolder.accessor$getTarget();
        if (entity == null) {
            return Optional.empty();
        }
        return Optional.of(((org.spongepowered.api.entity.Entity)entity).createSnapshot());
    }

    @Override
    protected ImmutableValue<EntitySnapshot> constructImmutableValue(EntitySnapshot value) {
        return new ImmutableSpongeValue<EntitySnapshot>(this.key, value);
    }

    @Override
    public boolean supports(ShulkerBulletEntityAccessor dataHolder) {
        return true;
    }

    @Override
    protected Value<EntitySnapshot> constructValue(EntitySnapshot actualValue) {
        return new SpongeValue<EntitySnapshot>(this.key, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (container instanceof ShulkerBulletEntityAccessor) {
            Entity target = ((ShulkerBulletEntityAccessor)((Object)container)).accessor$getTarget();
            if (target == null) {
                return DataTransactionResult.successNoData();
            }
            DataTransactionResult result = DataTransactionResult.builder().replace(new ImmutableSpongeValue<EntitySnapshot>(Keys.TARGETED_ENTITY, ((org.spongepowered.api.entity.Entity)target).createSnapshot())).result(DataTransactionResult.Type.SUCCESS).build();
            ((ShulkerBulletEntityAccessor)((Object)container)).accessor$setTarget(null);
            ((ShulkerBulletEntityAccessor)((Object)container)).accessor$setTargetId(null);
            return result;
        }
        return DataTransactionResult.successNoData();
    }

    @Override
    protected TargetedEntityData createManipulator() {
        return new SpongeTargetedEntityData(null);
    }
}

