/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableTargetedLocationData;
import org.spongepowered.api.data.manipulator.mutable.TargetedLocationData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.bridge.LocationTargetingBridge;
import org.spongepowered.common.data.manipulator.mutable.SpongeTargetedLocationData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public final class EntityTargetedLocationDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, Vector3d, Value<Vector3d>, TargetedLocationData, ImmutableTargetedLocationData> {
    public EntityTargetedLocationDataProcessor() {
        super(Entity.class, Keys.TARGETED_LOCATION);
    }

    @Override
    protected boolean set(Entity entity, Vector3d value) {
        if (entity instanceof LocationTargetingBridge) {
            ((LocationTargetingBridge)entity).bridge$setTargetedLocation(value);
            return true;
        }
        return false;
    }

    @Override
    protected Optional<Vector3d> getVal(Entity entity) {
        if (entity instanceof LocationTargetingBridge) {
            return Optional.of(((LocationTargetingBridge)entity).bridge$getTargetedLocation());
        }
        return Optional.empty();
    }

    @Override
    protected ImmutableValue<Vector3d> constructImmutableValue(Vector3d value) {
        return new ImmutableSpongeValue<Vector3d>(this.key, Vector3d.ZERO, value);
    }

    @Override
    protected Value<Vector3d> constructValue(Vector3d actualValue) {
        return new SpongeValue<Vector3d>(this.key, Vector3d.ZERO, actualValue);
    }

    @Override
    protected TargetedLocationData createManipulator() {
        return new SpongeTargetedLocationData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean supports(Entity entity) {
        return entity instanceof LocationTargetingBridge;
    }
}

