/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.monster.EntityShulker;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.manipulator.mutable.block.DirectionalData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.bridge.entity.monster.EntityShulkerBridge;
import org.spongepowered.common.data.manipulator.mutable.block.SpongeDirectionalData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class ShulkerDirectionalDataProcessor
extends AbstractEntitySingleDataProcessor<EntityShulker, Direction, Value<Direction>, DirectionalData, ImmutableDirectionalData> {
    public ShulkerDirectionalDataProcessor() {
        super(EntityShulker.class, Keys.DIRECTION);
    }

    @Override
    protected boolean set(EntityShulker dataHolder, Direction value) {
        ((EntityShulkerBridge)dataHolder).bridge$setDirection(value);
        return true;
    }

    @Override
    protected Optional<Direction> getVal(EntityShulker dataHolder) {
        return Optional.ofNullable(((EntityShulkerBridge)dataHolder).bridge$getDirection());
    }

    @Override
    protected ImmutableValue<Direction> constructImmutableValue(Direction value) {
        return new ImmutableSpongeValue<Direction>(Keys.DIRECTION, Direction.NONE, value);
    }

    @Override
    public boolean supports(EntityShulker dataHolder) {
        return dataHolder instanceof EntityShulkerBridge;
    }

    @Override
    protected Value<Direction> constructValue(Direction actualValue) {
        return new SpongeValue<Direction>(Keys.DIRECTION, Direction.NONE, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected DirectionalData createManipulator() {
        return new SpongeDirectionalData();
    }
}

