/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableSkinData;
import org.spongepowered.api.data.manipulator.mutable.entity.SkinData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeSkinData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.entity.living.human.EntityHuman;

public class SkinDataProcessor
extends AbstractEntitySingleDataProcessor<EntityHuman, UUID, Value<UUID>, SkinData, ImmutableSkinData> {
    public SkinDataProcessor() {
        super(EntityHuman.class, Keys.SKIN_UNIQUE_ID);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!(container instanceof EntityHuman)) {
            return DataTransactionResult.failNoData();
        }
        return ((EntityHuman)((Object)container)).removeSkin();
    }

    @Override
    protected Value<UUID> constructValue(UUID actualValue) {
        return new SpongeValue<UUID>(Keys.SKIN_UNIQUE_ID, actualValue);
    }

    @Override
    protected boolean set(EntityHuman entity, UUID value) {
        return entity.setSkinUuid(value);
    }

    @Override
    protected Optional<UUID> getVal(EntityHuman entity) {
        return Optional.ofNullable(entity.getSkinUuid());
    }

    @Override
    protected ImmutableValue<UUID> constructImmutableValue(UUID value) {
        return new ImmutableSpongeValue<UUID>(Keys.SKIN_UNIQUE_ID, value);
    }

    @Override
    protected SkinData createManipulator() {
        return new SpongeSkinData();
    }
}

