/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableWetData;
import org.spongepowered.api.data.manipulator.mutable.WetData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.SpongeWetData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.mixin.core.entity.passive.EntityWolfAccessor;

public class WolfWetDataProcessor
extends AbstractSingleDataSingleTargetProcessor<EntityWolfAccessor, Boolean, Value<Boolean>, WetData, ImmutableWetData> {
    public WolfWetDataProcessor() {
        super(Keys.IS_WET, EntityWolfAccessor.class);
    }

    @Override
    protected boolean set(EntityWolfAccessor entity, Boolean value) {
        if (value.booleanValue()) {
            entity.accessor$setIsWet(true);
            entity.accessor$setIsShaking(true);
            entity.accessor$setTimeShaking(0.0f);
            entity.accessor$setPreviousTimeShaking(0.0f);
        } else {
            entity.accessor$setIsWet(false);
            entity.accessor$setIsShaking(false);
            entity.accessor$setTimeShaking(0.0f);
            entity.accessor$setPreviousTimeShaking(0.0f);
        }
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(EntityWolfAccessor entity) {
        boolean isWet = entity.accessor$getIsWet() || entity.accessor$getIsShaking();
        return Optional.of(isWet);
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(Keys.IS_WET, false, actualValue);
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.IS_WET, false, value);
    }

    @Override
    protected WetData createManipulator() {
        return new SpongeWetData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

