/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableLoreData;
import org.spongepowered.api.data.manipulator.mutable.item.LoreData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeLoreData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;
import org.spongepowered.common.text.SpongeTexts;

public class ItemLoreDataProcessor
extends AbstractItemSingleDataProcessor<List<Text>, ListValue<Text>, LoreData, ImmutableLoreData> {
    public ItemLoreDataProcessor() {
        super((ItemStack input) -> true, Keys.ITEM_LORE);
    }

    @Override
    public Optional<LoreData> fill(DataContainer container, LoreData loreData) {
        List json = DataUtil.getData((DataView)container, Keys.ITEM_LORE, List.class);
        return Optional.of(loreData.set(Keys.ITEM_LORE, SpongeTexts.fromJson(json)));
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (this.supports(container)) {
            ItemStack stack = (ItemStack)container;
            Optional<List<Text>> old = this.getVal(stack);
            if (!old.isPresent()) {
                return DataTransactionResult.successNoData();
            }
            if (stack.func_179543_a("display") != null) {
                stack.func_179543_a("display").func_82580_o("Lore");
            }
            return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected LoreData createManipulator() {
        return new SpongeLoreData();
    }

    @Override
    protected boolean set(ItemStack itemStack, List<Text> value) {
        NBTTagList list = SpongeTexts.asLegacy(value);
        itemStack.func_190925_c("display").func_74782_a("Lore", (NBTBase)list);
        return true;
    }

    @Override
    protected Optional<List<Text>> getVal(ItemStack itemStack) {
        NBTTagCompound subCompound = itemStack.func_179543_a("display");
        if (subCompound == null) {
            return Optional.empty();
        }
        if (!subCompound.func_150297_b("Lore", 9)) {
            return Optional.empty();
        }
        NBTTagList list = subCompound.func_150295_c("Lore", 8);
        return Optional.of(SpongeTexts.fromNbtLegacy(list));
    }

    @Override
    protected ListValue<Text> constructValue(List<Text> defaultValue) {
        return new SpongeListValue<Text>(Keys.ITEM_LORE, defaultValue);
    }

    @Override
    protected ImmutableValue<List<Text>> constructImmutableValue(List<Text> value) {
        return new ImmutableSpongeListValue<Text>(Keys.ITEM_LORE, ImmutableList.copyOf(value));
    }
}

