/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutablePlaceableData;
import org.spongepowered.api.data.manipulator.mutable.item.PlaceableData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableSetValue;
import org.spongepowered.api.data.value.mutable.SetValue;
import org.spongepowered.common.data.manipulator.mutable.item.SpongePlaceableData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.processor.common.BreakablePlaceableUtils;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeSetValue;
import org.spongepowered.common.data.value.mutable.SpongeSetValue;

public class PlaceableDataProcessor
extends AbstractItemSingleDataProcessor<Set<BlockType>, SetValue<BlockType>, PlaceableData, ImmutablePlaceableData> {
    public PlaceableDataProcessor() {
        super((ItemStack stack) -> true, Keys.PLACEABLE_BLOCKS);
    }

    @Override
    protected PlaceableData createManipulator() {
        return new SpongePlaceableData();
    }

    @Override
    protected Optional<Set<BlockType>> getVal(ItemStack itemStack) {
        return BreakablePlaceableUtils.get(itemStack, "CanPlaceOn");
    }

    @Override
    protected boolean set(ItemStack itemStack, Set<BlockType> value) {
        return BreakablePlaceableUtils.set(itemStack, "CanPlaceOn", value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (this.supports(container)) {
            ItemStack stack = (ItemStack)container;
            Optional<Set<BlockType>> old = this.getVal(stack);
            if (!old.isPresent()) {
                return DataTransactionResult.successNoData();
            }
            if (this.set(stack, (Set<BlockType>)ImmutableSet.of())) {
                return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
            }
            return DataTransactionResult.builder().result(DataTransactionResult.Type.ERROR).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected SetValue<BlockType> constructValue(Set<BlockType> actualValue) {
        return new SpongeSetValue<BlockType>(Keys.PLACEABLE_BLOCKS, actualValue);
    }

    @Override
    protected ImmutableSetValue<BlockType> constructImmutableValue(Set<BlockType> value) {
        return new ImmutableSpongeSetValue<BlockType>(Keys.PLACEABLE_BLOCKS, value);
    }
}

