/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableBreathingData;
import org.spongepowered.api.data.manipulator.mutable.entity.BreathingData;
import org.spongepowered.common.bridge.entity.LivingEntityBaseBridge;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeBreathingData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataUtil;

public class BreathingDataProcessor
extends AbstractEntityDataProcessor<EntityLivingBase, BreathingData, ImmutableBreathingData> {
    public BreathingDataProcessor() {
        super(EntityLivingBase.class);
    }

    @Override
    protected BreathingData createManipulator() {
        return new SpongeBreathingData(300, 300);
    }

    @Override
    protected boolean doesDataExist(EntityLivingBase entity) {
        return entity.func_70090_H();
    }

    @Override
    protected boolean set(EntityLivingBase entity, Map<Key<?>, Object> keyValues) {
        int air = (Integer)keyValues.get(Keys.REMAINING_AIR);
        entity.func_70050_g(air);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityLivingBase entity) {
        return ImmutableMap.of(Keys.MAX_AIR, (Object)((LivingEntityBaseBridge)entity).bridge$getMaxAir(), Keys.REMAINING_AIR, (Object)entity.func_70086_ai());
    }

    @Override
    public Optional<BreathingData> fill(DataContainer container, BreathingData breathingData) {
        breathingData.set(Keys.MAX_AIR, DataUtil.getData(container, Keys.MAX_AIR));
        breathingData.set(Keys.REMAINING_AIR, DataUtil.getData(container, Keys.REMAINING_AIR));
        return Optional.of(breathingData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

