/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableDurabilityData;
import org.spongepowered.api.data.manipulator.mutable.item.DurabilityData;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeDurabilityData;
import org.spongepowered.common.data.processor.common.AbstractItemDataProcessor;

public class DurabilityDataProcessor
extends AbstractItemDataProcessor<DurabilityData, ImmutableDurabilityData> {
    public DurabilityDataProcessor() {
        super((ItemStack input) -> input.func_77973_b().func_77645_m());
    }

    @Override
    public boolean doesDataExist(ItemStack itemStack) {
        return itemStack.func_77973_b().func_77645_m();
    }

    @Override
    public boolean set(ItemStack itemStack, Map<Key<?>, Object> keyValues) {
        itemStack.func_77964_b(itemStack.func_77958_k() - (Integer)keyValues.get(Keys.ITEM_DURABILITY));
        boolean unbreakable = (Boolean)keyValues.get(Keys.UNBREAKABLE);
        if (unbreakable) {
            itemStack.func_77964_b(0);
        }
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74757_a("Unbreakable", unbreakable);
        return true;
    }

    @Override
    public Map<Key<?>, ?> getValues(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Unbreakable")) {
            return ImmutableMap.of(Keys.ITEM_DURABILITY, (Object)(itemStack.func_77958_k() - itemStack.func_77952_i()), Keys.UNBREAKABLE, (Object)itemStack.func_77978_p().func_74767_n("Unbreakable"));
        }
        return ImmutableMap.of(Keys.ITEM_DURABILITY, (Object)(itemStack.func_77958_k() - itemStack.func_77952_i()), Keys.UNBREAKABLE, (Object)false);
    }

    @Override
    public DurabilityData createManipulator() {
        return new SpongeDurabilityData();
    }

    @Override
    public Optional<DurabilityData> fill(DataContainer container, DurabilityData durabilityData) {
        Optional<Integer> durability = container.getInt(Keys.ITEM_DURABILITY.getQuery());
        Optional<Boolean> unbreakable = container.getBoolean(Keys.UNBREAKABLE.getQuery());
        if (durability.isPresent() && unbreakable.isPresent()) {
            durabilityData.set(Keys.ITEM_DURABILITY, durability.get());
            durabilityData.set(Keys.UNBREAKABLE, unbreakable.get());
            return Optional.of(durabilityData);
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

