/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.property;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.property.PropertyHolder;
import org.spongepowered.api.data.property.PropertyStore;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class PropertyStoreDelegate<T extends Property<?, ?>>
implements PropertyStore<T> {
    private final ImmutableList<PropertyStore<T>> propertyStores;

    public PropertyStoreDelegate(ImmutableList<PropertyStore<T>> propertyStores) {
        this.propertyStores = propertyStores;
    }

    @Override
    public Optional<T> getFor(PropertyHolder propertyHolder) {
        for (PropertyStore propertyStore : this.propertyStores) {
            Optional optional = propertyStore.getFor(propertyHolder);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public Optional<T> getFor(Location<World> location) {
        for (PropertyStore propertyStore : this.propertyStores) {
            Optional optional = propertyStore.getFor(location);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public Optional<T> getFor(Location<World> location, Direction direction) {
        for (PropertyStore propertyStore : this.propertyStores) {
            Optional optional = propertyStore.getFor(location, direction);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

