/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.property.store.common;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.property.PropertyHolder;
import org.spongepowered.api.data.property.PropertyStore;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;

public abstract class AbstractSpongePropertyStore<T extends Property<?, ?>>
implements PropertyStore<T> {
    @Override
    public Optional<T> getFor(PropertyHolder propertyHolder) {
        if (propertyHolder instanceof Location && ((Location)propertyHolder).getExtent() instanceof World) {
            return this.getFor((Location)propertyHolder);
        }
        return Optional.empty();
    }

    @Override
    public int getPriority() {
        return 100;
    }

    public static EnumFacing toEnumFacing(Direction direction) {
        Preconditions.checkArgument((direction.isCardinal() || direction.isUpright() ? 1 : 0) != 0, (Object)"Direction must be a valid block face");
        return DirectionFacingProvider.getInstance().get(direction).get();
    }
}

