/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.common.effect.particle.ICachedParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleType;
import org.spongepowered.common.util.Constants;

public class SpongeParticleEffect
implements ParticleEffect {
    @Nullable
    ICachedParticleEffect cachedParticle;
    private final SpongeParticleType type;
    private final Map<ParticleOption<?>, Object> options;

    public SpongeParticleEffect(SpongeParticleType type, Map<ParticleOption<?>, Object> options) {
        this.options = ImmutableMap.copyOf(options);
        this.type = type;
    }

    @Override
    public SpongeParticleType getType() {
        return this.type;
    }

    @Override
    public <V> Optional<V> getOption(ParticleOption<V> option) {
        return Optional.ofNullable(this.options.get(option));
    }

    @Override
    public Map<ParticleOption<?>, Object> getOptions() {
        return this.options;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer dataContainer = DataContainer.createNew();
        dataContainer.set(Constants.Particles.PARTICLE_TYPE, (Object)this.type);
        dataContainer.set(Constants.Particles.PARTICLE_OPTIONS, this.options.entrySet().stream().map(entry -> DataContainer.createNew().set(Constants.Particles.PARTICLE_OPTION_KEY, entry.getKey()).set(Constants.Particles.PARTICLE_OPTION_VALUE, entry.getValue())).collect(Collectors.toList()));
        return dataContainer;
    }
}

