/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.nbt.NbtDataType;
import org.spongepowered.common.data.nbt.NbtDataTypes;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.Validations;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.util.Constants;

public class SpongeEntityArchetype
extends AbstractArchetype<EntityType, EntitySnapshot, org.spongepowered.api.entity.Entity>
implements EntityArchetype {
    @Nullable
    private Vector3d position;

    SpongeEntityArchetype(SpongeEntityArchetypeBuilder builder) {
        super(builder.entityType, builder.compound != null ? builder.compound : (builder.entityData == null ? new NBTTagCompound() : NbtTranslator.getInstance().translateData(builder.entityData)));
    }

    @Override
    public EntityType getType() {
        return (EntityType)this.type;
    }

    @Nullable
    public NBTTagCompound getData() {
        return this.data;
    }

    public Optional<Vector3d> getPosition() {
        if (this.position != null) {
            return Optional.of(this.position);
        }
        if (!this.data.func_150297_b("Pos", 9)) {
            return Optional.empty();
        }
        try {
            NBTTagList pos = this.data.func_150295_c("Pos", 6);
            double x = pos.func_150309_d(0);
            double y = pos.func_150309_d(1);
            double z = pos.func_150309_d(2);
            this.position = new Vector3d(x, y, z);
            return Optional.of(this.position);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public DataContainer getEntityData() {
        return NbtTranslator.getInstance().translateFrom(this.data);
    }

    @Override
    public Optional<org.spongepowered.api.entity.Entity> apply(Location<org.spongepowered.api.world.World> location) {
        boolean requiresInitialSpawn;
        Vector3d position = location.getPosition();
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        BlockPos blockPos = new BlockPos(x, y, z);
        org.spongepowered.api.world.World world = location.getExtent();
        WorldServer worldServer = (WorldServer)world;
        Entity entity = null;
        try {
            Class<? extends org.spongepowered.api.entity.Entity> oclass = ((EntityType)this.type).getEntityClass();
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            return Optional.empty();
        }
        this.data.func_74782_a("Pos", (NBTBase)Constants.NBT.newDoubleNBTList(x, y, z));
        this.data.func_74768_a("Dimension", ((WorldInfoBridge)((Object)location.getExtent().getProperties())).bridge$getDimensionId().intValue());
        if (this.data.func_74764_b("RequireInitialSpawn")) {
            requiresInitialSpawn = !this.data.func_74767_n("RequireInitialSpawn");
            this.data.func_82580_o("RequireInitialSpawn");
        } else {
            requiresInitialSpawn = true;
        }
        entity.func_70020_e(this.data);
        this.data.func_82580_o("Pos");
        this.data.func_82580_o("Dimension");
        org.spongepowered.api.entity.Entity spongeEntity = (org.spongepowered.api.entity.Entity)entity;
        ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
        entities.add(spongeEntity);
        SpawnType require = Sponge.getCauseStackManager().getCurrentContext().require(EventContextKeys.SPAWN_TYPE);
        if (ShouldFire.SPAWN_ENTITY_EVENT_CUSTOM) {
            SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                return Optional.empty();
            }
        }
        WorldServerBridge mixinWorldServer = (WorldServerBridge)worldServer;
        entity.func_70080_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
        mixinWorldServer.bridge$forceSpawnEntity(entity);
        if (entity instanceof EntityLiving) {
            if (requiresInitialSpawn) {
                ((EntityLiving)entity).func_180482_a(worldServer.func_175649_E(blockPos), null);
            }
            ((EntityLiving)entity).func_70656_aK();
        }
        return Optional.of(spongeEntity);
    }

    @Override
    public EntitySnapshot toSnapshot(Location<org.spongepowered.api.world.World> location) {
        SpongeEntitySnapshotBuilder builder = new SpongeEntitySnapshotBuilder();
        builder.entityType = (EntityType)this.type;
        NBTTagCompound newCompound = this.data.func_74737_b();
        newCompound.func_74782_a("Pos", (NBTBase)Constants.NBT.newDoubleNBTList(location.getPosition().getX(), location.getPosition().getY(), location.getPosition().getZ()));
        newCompound.func_74768_a("Dimension", ((WorldInfoBridge)((Object)location.getExtent().getProperties())).bridge$getDimensionId().intValue());
        builder.compound = newCompound;
        builder.worldId = location.getExtent().getUniqueId();
        builder.position = location.getPosition();
        return builder.build();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Constants.Sponge.EntityArchetype.ENTITY_TYPE, (Object)this.type).set(Constants.Sponge.EntityArchetype.ENTITY_DATA, (Object)this.getEntityData());
    }

    @Override
    protected NbtDataType getDataType() {
        return NbtDataTypes.ENTITY;
    }

    @Override
    protected ValidationType getValidationType() {
        return Validations.ENTITY;
    }

    @Override
    public EntityArchetype copy() {
        SpongeEntityArchetypeBuilder builder = new SpongeEntityArchetypeBuilder();
        builder.entityType = (EntityType)this.type;
        builder.entityData = NbtTranslator.getInstance().translate(this.data);
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeEntityArchetype that = (SpongeEntityArchetype)o;
        return Objects.equals(this.position, that.position);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.position);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("position", (Object)this.position).add("type", (Object)this.type).toString();
    }
}

