/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.ArmorEquipable;
import org.spongepowered.api.entity.Tamer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.util.RespawnLocation;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.entity.player.BedLocationsBridge;
import org.spongepowered.common.data.type.SpongeEquipmentType;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.entity.player.SpongeUserInventory;
import org.spongepowered.common.entity.player.SpongeUserInventoryEnderchest;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.storage.SaveHandlerAccessor;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.WorldManager;

public class SpongeUser
implements ArmorEquipable,
Tamer,
DataSerializable,
Carrier,
BedLocationsBridge {
    public static final Set<SpongeUser> dirtyUsers = ConcurrentHashMap.newKeySet();
    public static final Set<SpongeUser> initializedUsers = ConcurrentHashMap.newKeySet();
    private final User self = (User)((Object)this);
    private final GameProfile profile;
    private final Map<UUID, RespawnLocation> spawnLocations = Maps.newHashMap();
    private double posX;
    private double posY;
    private double posZ;
    private int dimension;
    private float rotationYaw;
    private float rotationPitch;
    private boolean invulnerable;
    private boolean isVanished;
    private boolean isInvisible;
    private boolean isVanishCollide;
    private boolean isVanishTarget;
    @Nullable
    private SpongeUserInventory inventory;
    @Nullable
    private InventoryEnderChest enderChest;
    @Nullable
    private NBTTagCompound nbt;
    private boolean isConstructing;

    public SpongeUser(GameProfile profile) {
        this.profile = profile;
    }

    private void reset() {
        this.spawnLocations.clear();
    }

    public boolean isInitialized() {
        return this.nbt != null;
    }

    public DataHolder getDataHolder(boolean markDirty) {
        if (this.self.isOnline()) {
            return this.self.getPlayer().get();
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        if (markDirty) {
            this.markDirty();
        }
        return (DataHolder)((Object)this);
    }

    public void invalidate() {
        this.nbt = null;
        this.inventory = null;
        this.enderChest = null;
        ((CustomDataHolderBridge)((Object)this)).bridge$getFailedData().clear();
        for (DataManipulator<?, ?> manipulator : ((CustomDataHolderBridge)((Object)this)).bridge$getCustomManipulators()) {
            ((CustomDataHolderBridge)((Object)this)).bridge$removeCustom(manipulator.getClass());
        }
        initializedUsers.remove(this);
    }

    public void initialize() {
        initializedUsers.add(this);
        this.nbt = new NBTTagCompound();
        Optional<WorldServer> worldServer = WorldManager.getWorldByDimensionId(0);
        if (!worldServer.isPresent()) {
            return;
        }
        SaveHandlerAccessor saveHandler = (SaveHandlerAccessor)worldServer.get().func_72860_G();
        File file = new File(saveHandler.accessor$getPlayersDirectory(), this.profile.getId().toString() + ".dat");
        if (!file.exists()) {
            return;
        }
        try (FileInputStream in = new FileInputStream(file);){
            this.readFromNbt(CompressedStreamTools.func_74796_a((InputStream)in));
        }
        catch (IOException e) {
            SpongeImpl.getLogger().warn("Corrupt user file {}", (Object)file, (Object)e);
        }
    }

    public void readFromNbt(NBTTagCompound compound) {
        this.reset();
        this.nbt = compound;
        NBTTagList position = compound.func_150295_c("Pos", 6);
        NBTTagList rotation = compound.func_150295_c("Rotation", 5);
        this.posX = position.func_150309_d(0);
        this.posY = position.func_150309_d(1);
        this.posZ = position.func_150309_d(2);
        this.rotationYaw = rotation.func_150308_e(0);
        this.rotationPitch = rotation.func_150308_e(1);
        this.dimension = compound.func_74764_b("Dimension") ? compound.func_74762_e("Dimension") : 0;
        this.invulnerable = compound.func_74767_n("Invulnerable");
        NBTTagCompound spongeCompound = compound.func_74775_l("ForgeData").func_74775_l("SpongeData");
        this.isConstructing = true;
        DataUtil.readCustomData(spongeCompound, (DataHolder)((Object)this));
        this.isConstructing = false;
        if (!spongeCompound.func_82582_d()) {
            this.isVanished = spongeCompound.func_74767_n("IsVanished");
            this.isInvisible = spongeCompound.func_74767_n("IsInvisible");
            if (this.isVanished) {
                this.isVanishTarget = spongeCompound.func_74767_n("VanishUnTargetable");
                this.isVanishCollide = spongeCompound.func_74767_n("VanishUnCollideable");
            }
            NBTTagList spawnList = spongeCompound.func_150295_c("Spawns", 10);
            for (int i = 0; i < spawnList.func_74745_c(); ++i) {
                NBTTagCompound spawnCompound = spawnList.func_150305_b(i);
                UUID uuid = spawnCompound.func_186857_a("UUID");
                if (uuid.getLeastSignificantBits() == 0L || uuid.getMostSignificantBits() == 0L) continue;
                double xPos = spawnCompound.func_74769_h("SpawnX");
                double yPos = spawnCompound.func_74769_h("SpawnY");
                double zPos = spawnCompound.func_74769_h("SpawnZ");
                boolean forced = spawnCompound.func_74767_n("SpawnForced");
                this.spawnLocations.put(uuid, new RespawnLocation.Builder().forceSpawn(forced).position(new Vector3d(xPos, yPos, zPos)).world(uuid).build());
            }
        }
    }

    private SpongeUser loadInventory() {
        if (this.inventory == null) {
            if (!this.isInitialized()) {
                this.initialize();
            }
            this.inventory = new SpongeUserInventory(this);
            NBTTagList nbttaglist = this.nbt.func_150295_c("Inventory", 10);
            this.inventory.readFromNBT(nbttaglist);
            this.inventory.currentItem = this.nbt.func_74762_e("SelectedItemSlot");
        }
        return this;
    }

    private SpongeUser loadEnderInventory() {
        if (this.enderChest == null) {
            if (!this.isInitialized()) {
                this.initialize();
            }
            this.enderChest = new SpongeUserInventoryEnderchest(this);
            if (this.nbt.func_150297_b("EnderItems", 9)) {
                NBTTagList nbttaglist1 = this.nbt.func_150295_c("EnderItems", 10);
                this.enderChest.func_70486_a(nbttaglist1);
            }
        }
        return this;
    }

    public void writeToNbt(NBTTagCompound compound) {
        this.loadInventory();
        this.loadEnderInventory();
        compound.func_74782_a("Inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagList()));
        compound.func_74782_a("EnderItems", (NBTBase)this.enderChest.func_70487_g());
        compound.func_74768_a("SelectedItemSlot", this.inventory.currentItem);
        compound.func_74782_a("Pos", (NBTBase)Constants.NBT.newDoubleNBTList(this.posX, this.posY, this.posZ));
        compound.func_74768_a("Dimension", this.dimension);
        compound.func_74782_a("Rotation", (NBTBase)Constants.NBT.newFloatNBTList(this.rotationYaw, this.rotationPitch));
        compound.func_74757_a("Invulnerable", this.invulnerable);
        NBTTagCompound forgeCompound = compound.func_74775_l("ForgeData");
        NBTTagCompound spongeCompound = forgeCompound.func_74775_l("SpongeData");
        spongeCompound.func_82580_o("Spawns");
        spongeCompound.func_82580_o("IsVanished");
        spongeCompound.func_82580_o("IsInvisible");
        spongeCompound.func_82580_o("VanishUnTargetable");
        spongeCompound.func_82580_o("VanishUnCollideable");
        NBTTagList spawnList = new NBTTagList();
        for (Map.Entry<UUID, RespawnLocation> entry : this.spawnLocations.entrySet()) {
            RespawnLocation respawn = entry.getValue();
            NBTTagCompound spawnCompound = new NBTTagCompound();
            spawnCompound.func_186854_a("UUID", entry.getKey());
            spawnCompound.func_74780_a("SpawnX", respawn.getPosition().getX());
            spawnCompound.func_74780_a("SpawnY", respawn.getPosition().getY());
            spawnCompound.func_74780_a("SpawnZ", respawn.getPosition().getZ());
            spawnCompound.func_74757_a("SpawnForced", false);
            spawnList.func_74742_a((NBTBase)spawnCompound);
        }
        if (!spawnList.func_82582_d()) {
            spongeCompound.func_74782_a("Spawns", (NBTBase)spawnList);
        }
        if (this.isVanished) {
            spongeCompound.func_74757_a("IsVanished", true);
            spongeCompound.func_74757_a("VanishUnCollideable", this.isVanishCollide);
            spongeCompound.func_74757_a("VanishUnTargetable", this.isVanishTarget);
        }
        if (this.isInvisible) {
            spongeCompound.func_74757_a("IsInvisible", true);
        }
        forgeCompound.func_74782_a("SpongeData", (NBTBase)spongeCompound);
        compound.func_74782_a("ForgeData", (NBTBase)forgeCompound);
        DataUtil.writeCustomData(spongeCompound, (DataHolder)((Object)this));
    }

    @Override
    public UUID getUniqueId() {
        return this.profile.getId();
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Constants.Entity.Player.UUID, (Object)this.profile.getId()).set(Constants.Entity.Player.NAME, (Object)this.profile.getName()).set(Constants.Entity.Player.SPAWNS, this.spawnLocations);
    }

    @Override
    public boolean canEquip(EquipmentType type) {
        return this.getForInventory(p -> p.canEquip(type), u -> true);
    }

    @Override
    public boolean canEquip(EquipmentType type, @Nullable ItemStack equipment) {
        return this.getForInventory(p -> p.canEquip(type, equipment), u -> true);
    }

    @Override
    public Optional<ItemStack> getEquipped(EquipmentType type) {
        return this.getForInventory(p -> p.getEquipped(type), u -> u.getEquippedItem(type));
    }

    @Override
    public boolean equip(EquipmentType type, @Nullable ItemStack equipment) {
        if (this.canEquip(type, equipment)) {
            this.setForInventory(p -> p.equip(type, equipment), u -> u.setEquippedItem(type, equipment));
            return true;
        }
        return false;
    }

    public CarriedInventory<?> getInventory() {
        return this.getForInventory(Carrier::getInventory, u -> (CarriedInventory)((Object)u.inventory));
    }

    @Override
    public Optional<ItemStack> getItemInHand(HandType handType) {
        if (handType == HandTypes.MAIN_HAND) {
            return this.getForInventory(p -> p.getItemInHand(handType), u -> u.getEquipped(EquipmentTypes.MAIN_HAND));
        }
        if (handType == HandTypes.OFF_HAND) {
            return this.getForInventory(p -> p.getItemInHand(handType), u -> u.getEquipped(EquipmentTypes.OFF_HAND));
        }
        throw new IllegalArgumentException("Invalid hand " + handType);
    }

    @Override
    public void setItemInHand(HandType handType, @Nullable ItemStack itemInHand) {
        if (handType == HandTypes.MAIN_HAND) {
            this.setForInventory(p -> p.setItemInHand(handType, itemInHand), u -> u.setEquippedItem(EquipmentTypes.MAIN_HAND, itemInHand));
        } else if (handType == HandTypes.OFF_HAND) {
            this.setForInventory(p -> p.setItemInHand(handType, itemInHand), u -> u.setEquippedItem(EquipmentTypes.OFF_HAND, itemInHand));
        } else {
            throw new IllegalArgumentException("Invalid hand " + handType);
        }
    }

    @Override
    public Map<UUID, RespawnLocation> bridge$getBedlocations() {
        Optional<Player> player = this.self.getPlayer();
        return player.map(value -> ((BedLocationsBridge)((Object)value)).bridge$getBedlocations()).orElse(this.spawnLocations);
    }

    @Override
    public boolean bridge$setBedLocations(Map<UUID, RespawnLocation> value) {
        Optional<Player> player = this.self.getPlayer();
        if (player.isPresent()) {
            return ((BedLocationsBridge)((Object)player.get())).bridge$setBedLocations(value);
        }
        this.spawnLocations.clear();
        this.spawnLocations.putAll(value);
        this.markDirty();
        return true;
    }

    @Override
    public ImmutableMap<UUID, RespawnLocation> bridge$removeAllBeds() {
        Optional<Player> player = this.self.getPlayer();
        if (player.isPresent()) {
            return ((BedLocationsBridge)((Object)player.get())).bridge$removeAllBeds();
        }
        ImmutableMap locations = ImmutableMap.copyOf(this.spawnLocations);
        this.spawnLocations.clear();
        this.markDirty();
        return locations;
    }

    public void markDirty() {
        if (this.isConstructing) {
            return;
        }
        if (!this.isInitialized()) {
            SpongeImpl.getLogger().warn("Unable to mark user data for [{}] as dirty, data is not initialized! Any changes may be lost.", (Object)this.profile.getId());
        } else {
            dirtyUsers.add(this);
        }
    }

    public void save() {
        NBTTagCompound tag;
        Preconditions.checkState((boolean)this.isInitialized(), (String)"User {} is not initialized", (Object)this.profile.getId());
        SaveHandlerAccessor saveHandler = (SaveHandlerAccessor)WorldManager.getWorldByDimensionId(0).get().func_72860_G();
        File dataFile = new File(saveHandler.accessor$getPlayersDirectory(), this.getUniqueId() + ".dat");
        try {
            tag = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(dataFile));
        }
        catch (IOException ignored) {
            tag = new NBTTagCompound();
        }
        this.writeToNbt(tag);
        try (FileOutputStream out = new FileOutputStream(dataFile);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)out);
            dirtyUsers.remove(this);
        }
        catch (IOException e) {
            SpongeImpl.getLogger().warn("Failed to save user file [{}]!", (Object)dataFile, (Object)e);
        }
    }

    private <T> T getForInventory(Function<? super Player, ? extends T> playerFunction, Function<? super SpongeUser, T> userFunction) {
        if (this.self.getPlayer().isPresent()) {
            return playerFunction.apply(this.self.getPlayer().get());
        }
        return userFunction.apply(this.loadInventory());
    }

    private void setForInventory(Consumer<? super Player> playerFunction, Consumer<? super SpongeUser> userFunction) {
        if (this.self.getPlayer().isPresent()) {
            playerFunction.accept(this.self.getPlayer().get());
            return;
        }
        userFunction.accept(this.loadInventory());
    }

    private Optional<ItemStack> getEquippedItem(EquipmentType type) {
        net.minecraft.item.ItemStack nmsItem;
        EntityEquipmentSlot[] slots;
        if (type instanceof SpongeEquipmentType && (slots = ((SpongeEquipmentType)type).getSlots()).length == 1 && !(nmsItem = this.getItemStackFromSlot(slots[0])).func_190926_b()) {
            return Optional.of(ItemStackUtil.fromNative(nmsItem));
        }
        return Optional.empty();
    }

    private void setEquippedItem(EquipmentType type, @Nullable ItemStack item) {
        EntityEquipmentSlot[] slots;
        EntityEquipmentSlot[] entityEquipmentSlotArray;
        int n;
        int n2;
        if (type instanceof SpongeEquipmentType && (n2 = 0) < (n = (entityEquipmentSlotArray = (slots = ((SpongeEquipmentType)type).getSlots())).length)) {
            EntityEquipmentSlot slot = entityEquipmentSlotArray[n2];
            this.setItemStackToSlot(slot, ItemStackUtil.toNative(item));
            return;
        }
    }

    private net.minecraft.item.ItemStack getItemStackFromSlot(EntityEquipmentSlot slotIn) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            return this.inventory.getCurrentItem();
        }
        if (slotIn == EntityEquipmentSlot.OFFHAND) {
            return (net.minecraft.item.ItemStack)this.inventory.offHandInventory.get(0);
        }
        return slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR ? (net.minecraft.item.ItemStack)this.inventory.armorInventory.get(slotIn.func_188454_b()) : net.minecraft.item.ItemStack.field_190927_a;
    }

    private void setItemStackToSlot(EntityEquipmentSlot slotIn, net.minecraft.item.ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            this.inventory.mainInventory.set(this.inventory.currentItem, (Object)stack);
        } else if (slotIn == EntityEquipmentSlot.OFFHAND) {
            this.inventory.offHandInventory.set(0, (Object)stack);
        } else if (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
            this.inventory.armorInventory.set(slotIn.func_188454_b(), (Object)stack);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpongeUser other = (SpongeUser)obj;
        return this.profile.getId().equals(other.profile.getId());
    }

    public int hashCode() {
        return this.profile.getId().hashCode();
    }
}

