/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.source.BlockProjectileSource;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.common.util.VecHelper;

public class ProjectileSourceSerializer {
    public static NBTBase toNbt(ProjectileSource projectileSource) {
        if (projectileSource instanceof org.spongepowered.api.entity.Entity) {
            return new NBTTagString(((org.spongepowered.api.entity.Entity)((Object)projectileSource)).getUniqueId().toString());
        }
        if (projectileSource instanceof BlockProjectileSource) {
            return new NBTTagLong(VecHelper.toBlockPos(((BlockProjectileSource)projectileSource).getLocation()).func_177986_g());
        }
        return null;
    }

    public static ProjectileSource fromNbt(World worldObj, NBTBase tag) {
        TileEntity tileEntity;
        BlockPos pos;
        org.spongepowered.api.entity.Entity entity;
        if (tag instanceof NBTTagString && (entity = (org.spongepowered.api.entity.Entity)((org.spongepowered.api.world.World)worldObj).getEntity(UUID.fromString(((NBTTagString)tag).func_150285_a_())).orElse(null)) instanceof ProjectileSource) {
            return (ProjectileSource)((Object)entity);
        }
        if (tag instanceof NBTTagLong && worldObj.func_175667_e(pos = BlockPos.func_177969_a((long)((NBTTagLong)tag).func_150291_c())) && (tileEntity = worldObj.func_175625_s(pos)) instanceof ProjectileSource) {
            return (ProjectileSource)tileEntity;
        }
        return ProjectileSource.UNKNOWN;
    }

    public static void writeSourceToNbt(NBTTagCompound compound, ProjectileSource projectileSource, Entity potentialEntity) {
        NBTBase projectileNbt;
        if (projectileSource == null && potentialEntity instanceof ProjectileSource) {
            projectileSource = (ProjectileSource)potentialEntity;
        }
        if ((projectileNbt = ProjectileSourceSerializer.toNbt(projectileSource)) != null) {
            compound.func_74782_a("projectileSource", projectileNbt);
        }
    }

    public static void readSourceFromNbt(NBTTagCompound compound, Projectile projectile) {
        if (compound.func_74764_b("projectileSource")) {
            projectile.setShooter(ProjectileSourceSerializer.fromNbt((World)projectile.getWorld(), compound.func_74781_a("projectileSource")));
        }
    }
}

