/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import java.util.ArrayDeque;
import javax.annotation.Nullable;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;

public abstract class PooledPhaseState<C extends PhaseContext<C>>
implements IPhaseState<C> {
    private final ArrayDeque<C> contextPool = PhaseTracker.SERVER.createContextPool(this);
    @Nullable
    private C cached;

    protected PooledPhaseState() {
    }

    @Override
    public final C createPhaseContext() {
        if (this.cached != null && !((PhaseContext)this.cached).isCompleted) {
            C cached = this.cached;
            this.cached = null;
            return cached;
        }
        PhaseContext peek = (PhaseContext)this.contextPool.pollFirst();
        if (peek != null) {
            this.cached = peek;
            return (C)peek;
        }
        this.cached = this.createNewContext();
        return this.cached;
    }

    final void releaseContextFromPool(C context) {
        if (this.cached == context) {
            return;
        }
        if (this.cached == null) {
            this.cached = context;
            return;
        }
        this.contextPool.push(context);
    }

    protected abstract C createNewContext();
}

