/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.entity;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.entity.BasicEntityContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhaseState;
import org.spongepowered.common.registry.type.event.SpawnTypeRegistryModule;

final class DeathUpdateState
extends EntityPhaseState<BasicEntityContext> {
    DeathUpdateState() {
    }

    @Override
    public BasicEntityContext createNewContext() {
        return (BasicEntityContext)((BasicEntityContext)new BasicEntityContext(this).addCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(BasicEntityContext context) {
        Entity dyingEntity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Dying entity not found!", context));
        context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            DamageSource damageSource = context.getDamageSource();
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                if (damageSource != null) {
                    frame.pushCause(damageSource);
                }
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                frame.pushCause(dyingEntity);
                SpongeCommonEventFactory.callDropItemCustom(items, context);
            }
        });
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            List<Entity> other;
            List<Entity> experience = entities.stream().filter(entity -> entity instanceof ExperienceOrb).collect(Collectors.toList());
            if (!experience.isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(dyingEntity);
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                    SpongeCommonEventFactory.callSpawnEntity(experience, context);
                }
            }
            if (!(other = entities.stream().filter(entity -> !(entity instanceof ExperienceOrb)).collect(Collectors.toList())).isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(dyingEntity);
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypeRegistryModule.ENTITY_DEATH);
                    SpongeCommonEventFactory.callSpawnEntity(other, context);
                }
            }
        });
        context.getPerEntityItemEntityDropSupplier().acceptAndClearIfNotEmpty(map -> {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                DamageSource damageSource = context.getDamageSource();
                if (damageSource != null) {
                    frame.pushCause(damageSource);
                }
                frame.pushCause(dyingEntity);
                for (Map.Entry entry : map.asMap().entrySet()) {
                    if (((UUID)entry.getKey()).equals(dyingEntity.getUniqueId())) {
                        frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                        SpongeCommonEventFactory.callDropItemCustom((List)entry.getValue(), context);
                        frame.popCause();
                        continue;
                    }
                    Optional<Entity> otherSource = dyingEntity.getWorld().getEntity((UUID)entry.getKey());
                    otherSource.ifPresent(other -> {
                        frame.pushCause(other);
                        frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                        SpongeCommonEventFactory.callDropItemCustom((List)entry.getValue(), context);
                        frame.popCause();
                    });
                }
            }
        });
        context.getPerEntityItemDropSupplier().acceptAndClearIfNotEmpty(map -> {});
        TrackingUtil.processBlockCaptures(context);
    }
}

