/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import java.util.ArrayList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;

abstract class GeneralState<G extends PhaseContext<G>>
extends PooledPhaseState<G>
implements IPhaseState<G> {
    private final String desc = TrackingUtil.phaseStateToString("General", this);

    GeneralState() {
    }

    @Override
    public abstract void unwind(G var1);

    @Override
    public boolean spawnEntityOrCapture(G context, Entity entity, int chunkX, int chunkZ) {
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PASSIVE);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl;
        }
    }

    public String toString() {
        return this.desc;
    }
}

