/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.plugin.ListenerPhaseState;
import org.spongepowered.common.event.tracking.phase.plugin.WorldTickContext;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

final class WorldTickPhaseState
extends ListenerPhaseState<WorldTickContext> {
    private final String desc;

    WorldTickPhaseState(String name) {
        this.desc = TrackingUtil.phaseStateToString("Plugin", name, this);
    }

    @Override
    public WorldTickContext createNewContext() {
        return (WorldTickContext)((WorldTickContext)new WorldTickContext(this).addCaptures()).player();
    }

    @Override
    public void unwind(WorldTickContext phaseContext) {
        Object container = phaseContext.getSource(Object.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a ServerTickEvent listener!", phaseContext));
        TrackingUtil.processBlockCaptures(phaseContext);
        phaseContext.getBlockItemDropSupplier().acceptAndClearIfNotEmpty(map -> map.asMap().forEach((key, value) -> {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                LocatableBlock block = new SpongeLocatableBlockBuilder().world((World)phaseContext.getWorld()).position(key.func_177958_n(), key.func_177956_o(), key.func_177952_p()).build();
                frame.pushCause(container);
                frame.pushCause(block);
                List<Entity> items = value.stream().map(entity -> (Entity)entity).collect(Collectors.toList());
                SpongeCommonEventFactory.callDropItemDestruct(items, phaseContext);
            }
        }));
    }

    @Override
    public String toString() {
        return this.desc;
    }
}

