/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import javax.annotation.Nullable;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.tracking.phase.tick.TickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;

public final class DimensionContext
extends TickContext<DimensionContext> {
    @Nullable
    private World world;

    DimensionContext() {
        super(TickPhase.Tick.DIMENSION);
    }

    public DimensionContext world(WorldServer worldServer) {
        this.world = (World)worldServer;
        return this;
    }

    public DimensionContext world(WorldServerBridge worldServer) {
        this.world = (World)((Object)worldServer);
        return this;
    }

    public World getWorld() throws IllegalStateException {
        if (this.world == null) {
            throw new IllegalStateException("Expected to be ticking on a world!");
        }
        return this.world;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s + "- %s: %s", "World", this.world);
    }

    @Override
    protected void reset() {
        super.reset();
        this.world = null;
    }
}

