/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.world.BlockChange;

abstract class LocationBasedTickPhaseState<T extends LocationBasedTickContext<T>>
extends TickPhaseState<T> {
    private final BiConsumer<CauseStackManager.StackFrame, T> LOCATION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> context.getSource(LocatableBlock.class).ifPresent(frame::pushCause));

    LocationBasedTickPhaseState() {
    }

    abstract LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> var1);

    @Override
    public BiConsumer<CauseStackManager.StackFrame, T> getFrameModifier() {
        return this.LOCATION_MODIFIER;
    }

    @Override
    public void associateNeighborStateNotifier(T context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        ((PhaseContext)context).applyNotifierIfAvailable(user -> {
            ChunkBridge mixinChunk = (ChunkBridge)minecraftWorld.func_175726_f(notifyPos);
            mixinChunk.bridge$addTrackedBlockPosition(block, notifyPos, (User)user, PlayerTracker.Type.NOTIFIER);
        });
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> snapshotTransaction, T context) {
        ((PhaseContext)context).applyNotifierIfAvailable(user -> {
            SpongeBlockSnapshot original = (SpongeBlockSnapshot)snapshotTransaction.getOriginal();
            Block block = (Block)original.getState().getType();
            BlockPos changedBlockPos = original.getBlockPos();
            original.getWorldServer().ifPresent(worldServer -> {
                ChunkBridge changedMixinChunk = (ChunkBridge)worldServer.func_175726_f(changedBlockPos);
                changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (User)user, PlayerTracker.Type.NOTIFIER);
                if (blockChange == BlockChange.PLACE) {
                    context.applyOwnerIfAvailable(owner -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (User)owner, PlayerTracker.Type.OWNER));
                }
            });
        });
    }
}

