/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.PlayerTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;

class PlayerTickPhaseState
extends TickPhaseState<PlayerTickContext> {
    PlayerTickPhaseState() {
    }

    @Override
    protected PlayerTickContext createNewContext() {
        return (PlayerTickContext)((PlayerTickContext)new PlayerTickContext().addCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(PlayerTickContext context) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a Player!", context));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PASSIVE);
            context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> SpongeCommonEventFactory.callSpawnEntity(entities, context));
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
                ArrayList<Entity> capturedEntities = new ArrayList<Entity>();
                for (EntityItem entity : entities) {
                    capturedEntities.add((Entity)entity);
                }
                SpongeCommonEventFactory.callSpawnEntity(capturedEntities, context);
            });
            TrackingUtil.processBlockCaptures(context);
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, PlayerTickContext context) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking TileEntity!", context));
        explosionContext.owner(player);
        explosionContext.notifier(player);
        explosionContext.source(player);
    }

    @Override
    public boolean spawnEntityOrCapture(PlayerTickContext context, Entity entity, int chunkX, int chunkZ) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a Player!", context));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PASSIVE);
            ArrayList<Entity> entities = new ArrayList<Entity>(1);
            entities.add(entity);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl;
        }
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public boolean doesDenyChunkRequests() {
        return false;
    }
}

