/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.comp;

import java.util.Optional;
import org.spongepowered.api.entity.ArmorEquipable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.property.EquipmentSlotType;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.EquipmentInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.EquipmentInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;

public class EquipmentInventoryLensImpl
extends OrderedInventoryLensImpl
implements EquipmentInventoryLens {
    public EquipmentInventoryLensImpl(int base, int size, int stride, SlotProvider slots, boolean isContainer) {
        super(base, size, stride, EquipmentInventoryAdapter.class, slots);
        if (isContainer) {
            this.initContainer(slots);
        } else {
            this.initInventory(slots);
        }
    }

    @Override
    protected void init(SlotProvider slots) {
    }

    private void initInventory(SlotProvider slots) {
        int index = this.base;
        int ord = 0;
        this.addSpanningChild(slots.getSlot(index), new SlotIndex(ord++), EquipmentSlotType.of(EquipmentTypes.BOOTS));
        this.addSpanningChild(slots.getSlot(index += this.stride), new SlotIndex(ord++), EquipmentSlotType.of(EquipmentTypes.LEGGINGS));
        this.addSpanningChild(slots.getSlot(index += this.stride), new SlotIndex(ord++), EquipmentSlotType.of(EquipmentTypes.CHESTPLATE));
        this.addSpanningChild(slots.getSlot(index += this.stride), new SlotIndex(ord), EquipmentSlotType.of(EquipmentTypes.HEADWEAR));
        this.cache();
    }

    private void initContainer(SlotProvider slots) {
        int index = this.base;
        int ord = 0;
        this.addSpanningChild(slots.getSlot(index), new SlotIndex(ord++), EquipmentSlotType.of(EquipmentTypes.HEADWEAR));
        this.addSpanningChild(slots.getSlot(index += this.stride), new SlotIndex(ord++), EquipmentSlotType.of(EquipmentTypes.CHESTPLATE));
        this.addSpanningChild(slots.getSlot(index += this.stride), new SlotIndex(ord++), EquipmentSlotType.of(EquipmentTypes.LEGGINGS));
        this.addSpanningChild(slots.getSlot(index += this.stride), new SlotIndex(ord), EquipmentSlotType.of(EquipmentTypes.BOOTS));
        this.cache();
    }

    @Override
    public InventoryAdapter getAdapter(Fabric inv, Inventory parent) {
        Optional opt;
        ArmorEquipable carrier = null;
        if (parent instanceof CarriedInventory && (opt = ((CarriedInventory)parent).getCarrier()).isPresent() && opt.get() instanceof ArmorEquipable) {
            carrier = (ArmorEquipable)opt.get();
        }
        return new EquipmentInventoryAdapter(carrier, inv, this, parent);
    }
}

