/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smelting;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipe;
import org.spongepowered.api.plugin.PluginContainer;

public final class CustomSmeltingRecipeIds {
    private static final Map<SmeltingRecipe, String> ids = new IdentityHashMap<SmeltingRecipe, String>();
    private static final Reference2IntMap<Class<?>> counters = new Reference2IntOpenHashMap();

    public static String getDefaultId(SmeltingRecipe recipe) {
        return ids.computeIfAbsent(recipe, CustomSmeltingRecipeIds::loadDefaultId);
    }

    private static String loadDefaultId(SmeltingRecipe recipe) {
        Class<?> clazz = recipe.getClass();
        int value = counters.getInt(clazz);
        counters.put(clazz, value + 1);
        String pluginId = Sponge.getCauseStackManager().getCurrentCause().first(PluginContainer.class).map(PluginContainer::getId).orElse("sponge");
        return pluginId + ":" + clazz.getName().replaceAll("[.$]", "_").toLowerCase() + "_" + value;
    }
}

