/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.data;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.ValueProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimings;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;

@Mixin(value={TileEntity.class, Entity.class, ItemStack.class, SpongeUser.class}, priority=899)
public abstract class DataHolderMixin_API
implements DataHolder {
    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        Optional<DataProcessor<?, ?>> optional;
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataGetManipulator.startTimingIfSync();
        boolean isUser = this instanceof SpongeUser;
        DataHolder holder = this;
        if (isUser) {
            holder = ((SpongeUser)((Object)holder)).getDataHolder(false);
        }
        if ((optional = DataUtil.getWildProcessor(containerClass)).isPresent()) {
            Optional<?> from = optional.get().from(holder);
            SpongeTimings.dataGetManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return from;
        }
        if (this instanceof CustomDataHolderBridge) {
            Optional<T> custom = ((CustomDataHolderBridge)((Object)holder)).bridge$getCustom(containerClass);
            SpongeTimings.dataGetManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return custom;
        }
        SpongeTimings.dataGetManipulator.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return Optional.empty();
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        Optional<DataProcessor<?, ?>> optional;
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataGetOrCreateManipulator.startTimingIfSync();
        boolean isUser = this instanceof SpongeUser;
        DataHolder holder = this;
        if (isUser) {
            holder = ((SpongeUser)((Object)holder)).getDataHolder(false);
        }
        if ((optional = DataUtil.getWildProcessor(containerClass)).isPresent()) {
            Optional<?> created = optional.get().createFrom(holder);
            SpongeTimings.dataGetOrCreateManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return created;
        }
        if (this instanceof CustomDataHolderBridge) {
            Optional<T> custom = ((CustomDataHolderBridge)((Object)holder)).bridge$getCustom(containerClass);
            if (custom.isPresent()) {
                SpongeTimings.dataGetOrCreateManipulator.stopTimingIfSync();
                TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
                return custom;
            }
            Optional<DataManipulatorBuilder<?, ?>> builder = SpongeDataManager.getInstance().getWildManipulatorBuilder(containerClass);
            Preconditions.checkState((boolean)builder.isPresent(), (Object)("A DataManipulatorBuilder is not registered for the manipulator class: " + containerClass.getName()));
            Object manipulator = builder.get().create();
            Optional<DataManipulator> other = manipulator.fill(holder).map(customManipulator -> customManipulator);
            SpongeTimings.dataGetOrCreateManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return other;
        }
        SpongeTimings.dataGetOrCreateManipulator.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return Optional.empty();
    }

    @Override
    public boolean supports(Class<? extends DataManipulator<?, ?>> holderClass) {
        Optional<DataProcessor<?, ?>> optional;
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataSupportsManipulator.startTimingIfSync();
        boolean isUser = this instanceof SpongeUser;
        DataHolder holder = this;
        if (isUser) {
            holder = ((SpongeUser)((Object)holder)).getDataHolder(false);
        }
        if ((optional = DataUtil.getWildProcessor(holderClass)).isPresent()) {
            boolean supports = optional.get().supports(holder);
            SpongeTimings.dataSupportsManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return supports;
        }
        if (this instanceof CustomDataHolderBridge) {
            Optional<DataManipulator<?, ?>> custom = ((CustomDataHolderBridge)((Object)holder)).bridge$getCustom(holderClass);
            if (custom.isPresent()) {
                SpongeTimings.dataSupportsManipulator.stopTimingIfSync();
                TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
                return true;
            }
            Optional<DataManipulatorBuilder<?, ?>> builder = SpongeDataManager.getInstance().getWildManipulatorBuilder(holderClass);
            Preconditions.checkState((boolean)builder.isPresent(), (Object)("A DataManipulatorBuilder is not registered for the manipulator class: " + holderClass.getName()));
            Object manipulator = builder.get().create();
            boolean present = manipulator.fill(holder).isPresent();
            SpongeTimings.dataSupportsManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return present;
        }
        SpongeTimings.dataSupportsManipulator.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return false;
    }

    @Override
    public <E> DataTransactionResult offer(Key<? extends BaseValue<E>> key, E value) {
        Optional optional;
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataOfferKey.startTimingIfSync();
        boolean isUser = this instanceof SpongeUser;
        DataHolder holder = this;
        if (isUser) {
            holder = ((SpongeUser)((Object)holder)).getDataHolder(true);
        }
        if ((optional = DataUtil.getBaseValueProcessor(key)).isPresent()) {
            DataTransactionResult result = optional.get().offerToStore(holder, value);
            SpongeTimings.dataOfferKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        if (this instanceof CustomDataHolderBridge) {
            DataTransactionResult result = ((CustomDataHolderBridge)((Object)holder)).bridge$offerCustom(key, value);
            SpongeTimings.dataOfferKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        SpongeTimings.dataOfferKey.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult offer(DataManipulator<?, ?> valueContainer, MergeFunction function) {
        Optional<DataProcessor> optional;
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataOfferManipulator.startTimingIfSync();
        boolean isUser = this instanceof SpongeUser;
        DataHolder holder = this;
        if (isUser) {
            holder = ((SpongeUser)((Object)holder)).getDataHolder(true);
        }
        if ((optional = DataUtil.getWildDataProcessor(valueContainer.getClass())).isPresent()) {
            DataTransactionResult result = optional.get().set(holder, valueContainer, (MergeFunction)Preconditions.checkNotNull((Object)function));
            SpongeTimings.dataOfferManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        if (this instanceof CustomDataHolderBridge) {
            DataTransactionResult result = ((CustomDataHolderBridge)((Object)holder)).bridge$offerCustom(valueContainer, function);
            SpongeTimings.dataOfferManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        SpongeTimings.dataOfferManipulator.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return DataTransactionResult.failResult(valueContainer.getValues());
    }

    @Override
    public DataTransactionResult offer(Iterable<DataManipulator<?, ?>> valueContainers) {
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataOfferMultiManipulators.startTimingIfSync();
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (DataManipulator<?, ?> manipulator : valueContainers) {
            DataTransactionResult result = this.offer(manipulator);
            if (!result.getRejectedData().isEmpty()) {
                builder.reject(result.getRejectedData());
            }
            if (!result.getReplacedData().isEmpty()) {
                builder.replace(result.getReplacedData());
            }
            if (!result.getSuccessfulData().isEmpty()) {
                builder.success(result.getSuccessfulData());
            }
            DataTransactionResult.Type type = result.getType();
            builder.result(type);
            switch (type) {
                case UNDEFINED: 
                case ERROR: 
                case CANCELLED: {
                    SpongeTimings.dataOfferMultiManipulators.stopTimingIfSync();
                    TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
                    return builder.build();
                }
            }
        }
        SpongeTimings.dataOfferMultiManipulators.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return builder.build();
    }

    @Override
    public DataTransactionResult remove(Class<? extends DataManipulator<?, ?>> containerClass) {
        Optional<DataProcessor<?, ?>> optional;
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataRemoveManipulator.startTimingIfSync();
        boolean isUser = this instanceof SpongeUser;
        DataHolder holder = this;
        if (isUser) {
            holder = ((SpongeUser)((Object)holder)).getDataHolder(true);
        }
        if ((optional = DataUtil.getWildProcessor(containerClass)).isPresent()) {
            DataTransactionResult result = optional.get().remove(holder);
            SpongeTimings.dataRemoveManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        if (this instanceof CustomDataHolderBridge) {
            DataTransactionResult result = ((CustomDataHolderBridge)((Object)holder)).bridge$removeCustom(containerClass);
            SpongeTimings.dataRemoveManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        SpongeTimings.dataOfferMultiManipulators.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult remove(Key<?> key) {
        Optional<ValueProcessor<?, ?>> optional;
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataRemoveKey.startTimingIfSync();
        boolean isUser = this instanceof SpongeUser;
        DataHolder holder = this;
        if (isUser) {
            holder = ((SpongeUser)((Object)holder)).getDataHolder(true);
        }
        if ((optional = DataUtil.getWildValueProcessor((Key)Preconditions.checkNotNull(key))).isPresent()) {
            DataTransactionResult result = optional.get().removeFrom(holder);
            SpongeTimings.dataRemoveKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        if (this instanceof CustomDataHolderBridge) {
            DataTransactionResult result = ((CustomDataHolderBridge)((Object)holder)).bridge$removeCustom(key);
            SpongeTimings.dataRemoveKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return result;
        }
        SpongeTimings.dataRemoveKey.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult undo(DataTransactionResult result) {
        SpongeTimings.dataOfferManipulator.startTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        if (result.getReplacedData().isEmpty() && result.getSuccessfulData().isEmpty()) {
            SpongeTimings.dataOfferManipulator.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return DataTransactionResult.successNoData();
        }
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (ImmutableValue<?> replaced : result.getReplacedData()) {
            builder.absorbResult(this.offer(replaced));
        }
        for (ImmutableValue<?> successful : result.getSuccessfulData()) {
            builder.absorbResult(this.remove(successful));
        }
        SpongeTimings.dataOfferManipulator.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return builder.build();
    }

    @Override
    public DataTransactionResult copyFrom(DataHolder that, MergeFunction function) {
        return this.offer(that.getContainers(), function);
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        Optional optional;
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataGetByKey.startTimingIfSync();
        boolean isUser = this instanceof SpongeUser;
        DataHolder holder = this;
        if (isUser) {
            holder = ((SpongeUser)((Object)holder)).getDataHolder(false);
        }
        if ((optional = DataUtil.getBaseValueProcessor((Key)Preconditions.checkNotNull(key))).isPresent()) {
            Optional value = optional.get().getValueFromContainer(holder);
            SpongeTimings.dataGetByKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return value;
        }
        if (this instanceof CustomDataHolderBridge) {
            Optional custom = ((CustomDataHolderBridge)((Object)holder)).bridge$getCustom(key);
            SpongeTimings.dataGetByKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return custom;
        }
        SpongeTimings.dataGetByKey.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return Optional.empty();
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        Optional optional;
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataGetValue.startTimingIfSync();
        boolean isUser = this instanceof SpongeUser;
        DataHolder holder = this;
        if (isUser) {
            holder = ((SpongeUser)((Object)holder)).getDataHolder(false);
        }
        if ((optional = DataUtil.getValueProcessor((Key)Preconditions.checkNotNull(key))).isPresent()) {
            Optional value = optional.get().getApiValueFromContainer(holder);
            SpongeTimings.dataGetValue.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return value;
        }
        if (this instanceof CustomDataHolderBridge) {
            Optional<V> customValue = ((CustomDataHolderBridge)((Object)holder)).bridge$getCustomValue(key);
            SpongeTimings.dataGetValue.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return customValue;
        }
        SpongeTimings.dataGetValue.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return Optional.empty();
    }

    @Override
    public boolean supports(Key<?> key) {
        Optional<ValueProcessor<?, ?>> optional;
        TimingsManager.DATA_GROUP_HANDLER.startTimingIfSync();
        SpongeTimings.dataSupportsKey.startTimingIfSync();
        boolean isUser = this instanceof SpongeUser;
        DataHolder holder = this;
        if (isUser) {
            holder = ((SpongeUser)((Object)holder)).getDataHolder(false);
        }
        if ((optional = DataUtil.getWildValueProcessor((Key)Preconditions.checkNotNull(key))).isPresent()) {
            boolean supports = optional.get().supports(holder);
            SpongeTimings.dataSupportsKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return supports;
        }
        if (this instanceof CustomDataHolderBridge) {
            boolean customSupport = ((CustomDataHolderBridge)((Object)holder)).bridge$supportsCustom(key);
            SpongeTimings.dataSupportsKey.stopTimingIfSync();
            TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
            return customSupport;
        }
        SpongeTimings.dataSupportsKey.stopTimingIfSync();
        TimingsManager.DATA_GROUP_HANDLER.stopTimingIfSync();
        return false;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.getContainers().stream().flatMap(container -> container.getKeys().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        return this.getContainers().stream().flatMap(container -> container.getValues().stream()).collect(Collectors.toSet());
    }

    @Override
    public boolean validateRawData(DataView container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        return Collections.emptyList();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew();
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        return Optional.empty();
    }

    @Override
    public Collection<Property<?, ?>> getApplicableProperties() {
        return Collections.emptyList();
    }

    @Override
    public DataHolder copy() {
        return this;
    }
}

