/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.scoreboard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketDisplayObjective;
import net.minecraft.network.play.server.SPacketScoreboardObjective;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.critieria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.text.Text;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.scoreboard.ScoreBridge;
import org.spongepowered.common.bridge.scoreboard.ScoreObjectiveBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.mixin.core.scoreboard.ScorePlayerTeamAccessor;
import org.spongepowered.common.mixin.core.scoreboard.ScoreboardAccessor;
import org.spongepowered.common.scoreboard.SpongeDisplaySlot;
import org.spongepowered.common.scoreboard.SpongeObjective;
import org.spongepowered.common.text.SpongeTexts;

@Mixin(value={ServerScoreboard.class})
@Implements(value={@Interface(iface=Scoreboard.class, prefix="scoreboard$")})
public abstract class ServerScoreboardMixin_API
extends net.minecraft.scoreboard.Scoreboard {
    @Shadow
    protected abstract void func_96551_b();

    public Optional<Objective> scoreboard$getObjective(String name) {
        ScoreObjective objective = this.func_96518_b(name);
        return Optional.ofNullable(objective == null ? null : ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    public void scoreboard$addObjective(Objective objective) {
        ScoreObjective nmsObjective = this.func_96518_b(objective.getName());
        if (nmsObjective != null) {
            throw new IllegalArgumentException("An objective with the name '" + objective.getName() + "' already exists!");
        }
        ScoreObjective scoreObjective = ((SpongeObjective)objective).getObjectiveFor(this);
        List<ScoreObjective> objectives = ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectiveCriterias().get(objective.getCriterion());
        if (objectives == null) {
            objectives = new ArrayList<ScoreObjective>();
            ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectiveCriterias().put((IScoreCriteria)objective.getCriterion(), objectives);
        }
        objectives.add(scoreObjective);
        ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectives().put(objective.getName(), scoreObjective);
        this.func_96522_a(scoreObjective);
        ((SpongeObjective)objective).updateScores(this);
    }

    public void scoreboard$updateDisplaySlot(@Nullable Objective objective, DisplaySlot displaySlot) throws IllegalStateException {
        if (objective != null && !objective.getScoreboards().contains((Object)this)) {
            throw new IllegalStateException("Attempting to set an objective's display slot that does not exist on this scoreboard!");
        }
        int index = ((SpongeDisplaySlot)displaySlot).getIndex();
        ((ScoreboardAccessor)((Object)this)).accessor$getObjectiveDisplaySlots()[index] = objective == null ? null : ((SpongeObjective)objective).getObjectiveFor(this);
        ((ServerScoreboardBridge)((Object)this)).bridge$sendToPlayers((Packet<?>)new SPacketDisplayObjective(index, ((ScoreboardAccessor)((Object)this)).accessor$getObjectiveDisplaySlots()[index]));
    }

    public Optional<Objective> scoreboard$getObjective(DisplaySlot slot) {
        ScoreObjective objective = ((ScoreboardAccessor)((Object)this)).accessor$getObjectiveDisplaySlots()[((SpongeDisplaySlot)slot).getIndex()];
        if (objective != null) {
            return Optional.of(((ScoreObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return Optional.empty();
    }

    public Set<Objective> scoreboard$getObjectivesByCriteria(Criterion criterion) {
        if (((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectiveCriterias().containsKey(criterion)) {
            return ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectiveCriterias().get(criterion).stream().map(objective -> ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
        }
        return new HashSet<Objective>();
    }

    public Set<Objective> scoreboard$getObjectives() {
        return ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectives().values().stream().map(objective -> ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
    }

    public void scoreboard$removeObjective(Objective objective) {
        ScoreObjective scoreObjective = ((SpongeObjective)objective).getObjectiveFor(this);
        ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectives().remove(scoreObjective.func_96679_b());
        for (int i = 0; i < 19; ++i) {
            if (this.func_96539_a(i) != scoreObjective) continue;
            this.func_96530_a(i, null);
        }
        ((ServerScoreboardBridge)((Object)this)).bridge$sendToPlayers((Packet<?>)new SPacketScoreboardObjective(scoreObjective, 1));
        List<ScoreObjective> list = ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectiveCriterias().get(scoreObjective.func_96680_c());
        if (list != null) {
            list.remove(scoreObjective);
        }
        for (Map<ScoreObjective, net.minecraft.scoreboard.Score> scoreMap : ((ScoreboardAccessor)((Object)this)).accessor$getEntitiesScoreObjectives().values()) {
            net.minecraft.scoreboard.Score score = scoreMap.remove(scoreObjective);
            if (score == null) continue;
            ((ScoreBridge)score).bridge$getSpongeScore().removeScoreFor(scoreObjective);
        }
        this.func_96551_b();
        ((SpongeObjective)objective).removeObjectiveFor(this);
    }

    public Optional<Team> scoreboard$getTeam(String name) {
        return Optional.ofNullable((Team)((ScoreboardAccessor)((Object)this)).accessor$getTeams().get(name));
    }

    public Set<Team> scoreboard$getTeams() {
        return new HashSet<ScorePlayerTeam>(((ScoreboardAccessor)((Object)this)).accessor$getTeams().values());
    }

    public Optional<Team> scoreboard$getMemberTeam(Text member) {
        return Optional.ofNullable((Team)((ScoreboardAccessor)((Object)this)).accessor$getTeamMemberships().get(SpongeTexts.toLegacy(member)));
    }

    public void scoreboard$registerTeam(Team spongeTeam) {
        ScorePlayerTeam team = (ScorePlayerTeam)spongeTeam;
        if (this.func_96508_e(spongeTeam.getName()) != null) {
            throw new IllegalArgumentException("A team with the name '" + spongeTeam.getName() + "' already exists!");
        }
        if (((ScorePlayerTeamAccessor)team).accessor$getScoreboard() != null) {
            throw new IllegalArgumentException("The passed in team is already registered to a scoreboard!");
        }
        ((ScorePlayerTeamAccessor)team).accessor$setScoreboard(this);
        ((ScoreboardAccessor)((Object)this)).accessor$getTeams().put(team.func_96661_b(), team);
        for (String entry : team.func_96670_d()) {
            this.func_151392_a(entry, team.func_96661_b());
        }
        this.func_96523_a(team);
    }

    public Set<Score> scoreboard$getScores() {
        HashSet<Score> scores = new HashSet<Score>();
        for (ScoreObjective objective : ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectives().values()) {
            scores.addAll(((ScoreObjectiveBridge)objective).bridge$getSpongeObjective().getScores().values());
        }
        return scores;
    }

    public Set<Score> scoreboard$getScores(Text name) {
        HashSet<Score> scores = new HashSet<Score>();
        for (ScoreObjective objective : ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectives().values()) {
            ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective().getScore(name).ifPresent(scores::add);
        }
        return scores;
    }

    public void scoreboard$removeScores(Text name) {
        for (ScoreObjective objective : ((ScoreboardAccessor)((Object)this)).accessor$getScoreObjectives().values()) {
            SpongeObjective spongeObjective = ((ScoreObjectiveBridge)objective).bridge$getSpongeObjective();
            spongeObjective.getScore(name).ifPresent(spongeObjective::removeScore);
        }
    }
}

