/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.gen.feature;

import com.flowpowered.math.vector.Vector3i;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.data.type.DoublePlantType;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.DoublePlant;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.gen.feature.WorldGenDoublePlantBridge;

@Mixin(value={WorldGenDoublePlant.class})
public abstract class WorldGenDoublePlantMixin_API
extends WorldGenerator
implements DoublePlant {
    @Shadow
    private BlockDoublePlant.EnumPlantType field_150549_a;
    private final WeightedTable<DoublePlantType> api$types = new WeightedTable();
    private VariableAmount api$count = VariableAmount.fixed(1.0);
    @Nullable
    private Function<Location<Extent>, DoublePlantType> api$override = null;

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.DOUBLE_PLANT;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        ((WorldGenDoublePlantBridge)((Object)this)).bridge$setCurrentExtent(extent);
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = (int)Math.ceil((float)this.api$count.getFlooredAmount(random) / 8.0f);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            int y = this.nextInt(random, world.func_175645_m(chunkPos.func_177982_a(x, 0, z)).func_177956_o() + 32);
            this.func_180709_b(world, random, world.func_175645_m(chunkPos.func_177982_a(x, y, z)));
        }
        ((WorldGenDoublePlantBridge)((Object)this)).bridge$setCurrentExtent(null);
    }

    private int nextInt(Random rand, int i) {
        if (i <= 1) {
            return 0;
        }
        return rand.nextInt(i);
    }

    @Override
    public WeightedTable<DoublePlantType> getPossibleTypes() {
        return this.api$types;
    }

    @Override
    public VariableAmount getPlantsPerChunk() {
        return this.api$count;
    }

    @Override
    public void setPlantsPerChunk(VariableAmount count) {
        this.api$count = count;
    }

    @Override
    public Optional<Function<Location<Extent>, DoublePlantType>> getSupplierOverride() {
        return Optional.ofNullable(this.api$override);
    }

    @Override
    public void setSupplierOverride(@Nullable Function<Location<Extent>, DoublePlantType> override) {
        this.api$override = override;
    }
}

