/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.api.text;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentBase;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.ShiftClickAction;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextFormat;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.api.text.TextBridge;
import org.spongepowered.common.bridge.util.text.ITextComponentBridge;
import org.spongepowered.common.text.action.SpongeClickAction;
import org.spongepowered.common.text.action.SpongeHoverAction;
import org.spongepowered.common.text.format.SpongeTextColor;

@Mixin(value={Text.class}, remap=false)
public abstract class TextMixin
implements TextBridge {
    @Shadow
    @Final
    TextFormat format;
    @Shadow
    @Final
    ImmutableList<Text> children;
    @Shadow
    @Final
    Optional<ClickAction<?>> clickAction;
    @Shadow
    @Final
    Optional<HoverAction<?>> hoverAction;
    @Shadow
    @Final
    Optional<ShiftClickAction<?>> shiftClickAction;
    private ITextComponent component;
    private String json;

    protected TextComponentBase createComponent() {
        throw new UnsupportedOperationException();
    }

    private ITextComponent initializeComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
            Style style = this.component.func_150256_b();
            if (this.format.getColor() != TextColors.NONE) {
                style.func_150238_a(((SpongeTextColor)this.format.getColor()).getHandle());
            }
            if (!this.format.getStyle().isEmpty()) {
                style.func_150227_a((Boolean)this.format.getStyle().isBold().orElse(null));
                style.func_150217_b((Boolean)this.format.getStyle().isItalic().orElse(null));
                style.func_150228_d((Boolean)this.format.getStyle().hasUnderline().orElse(null));
                style.func_150225_c((Boolean)this.format.getStyle().hasStrikethrough().orElse(null));
                style.func_150237_e((Boolean)this.format.getStyle().isObfuscated().orElse(null));
            }
            if (this.clickAction.isPresent()) {
                style.func_150241_a(SpongeClickAction.getHandle(this.clickAction.get()));
            }
            if (this.hoverAction.isPresent()) {
                style.func_150209_a(SpongeHoverAction.getHandle(this.hoverAction.get()));
            }
            if (this.shiftClickAction.isPresent()) {
                ShiftClickAction.InsertText insertion = (ShiftClickAction.InsertText)this.shiftClickAction.get();
                style.func_179989_a((String)insertion.getResult());
            }
            for (Text child : this.children) {
                this.component.func_150257_a(((TextBridge)((Object)child)).bridge$toComponent());
            }
        }
        return this.component;
    }

    private ITextComponent getHandle() {
        return this.initializeComponent();
    }

    @Override
    public ITextComponent bridge$toComponent() {
        return this.getHandle().func_150259_f();
    }

    @Overwrite
    public final String toPlain() {
        return ((ITextComponentBridge)this.getHandle()).bridge$toPlain();
    }

    @Overwrite
    public final String toPlainSingle() {
        return this.getHandle().func_150261_e();
    }

    @Override
    public String bridge$toJson() {
        if (this.json == null) {
            this.json = ITextComponent.Serializer.func_150696_a((ITextComponent)this.getHandle());
        }
        return this.json;
    }

    @Override
    public String bridge$toLegacy(char code) {
        return ((ITextComponentBridge)this.getHandle()).bridge$toLegacy(code);
    }
}

