/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableLogAxisData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableTreeData;
import org.spongepowered.api.data.type.LogAxis;
import org.spongepowered.api.data.type.TreeType;
import org.spongepowered.api.data.type.TreeTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeLogAxisData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeTreeData;
import org.spongepowered.common.mixin.core.block.BlockMixin;
import org.spongepowered.common.registry.type.block.TreeTypeRegistryModule;

@Mixin(value={BlockLog.class})
public abstract class BlockLogMixin
extends BlockMixin {
    private ImmutableTreeData getTreeData(IBlockState blockState) {
        BlockPlanks.EnumType type = blockState.func_177230_c() instanceof BlockOldLog ? (BlockPlanks.EnumType)blockState.func_177229_b((IProperty)BlockOldLog.field_176301_b) : (blockState.func_177230_c() instanceof BlockNewLog ? (BlockPlanks.EnumType)blockState.func_177229_b((IProperty)BlockNewLog.field_176300_b) : BlockPlanks.EnumType.OAK);
        TreeType treeType = TreeTypeRegistryModule.getFor(type);
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeTreeData.class, treeType);
    }

    private ImmutableLogAxisData getLogAxisData(IBlockState blockState) {
        LogAxis logAxis = (LogAxis)((Object)blockState.func_177229_b((IProperty)BlockLog.field_176299_a));
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeLogAxisData.class, logAxis);
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableTreeData.class.isAssignableFrom(immutable) || ImmutableLogAxisData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableTreeData) {
            TreeType treeType = (TreeType)((ImmutableTreeData)manipulator).type().get();
            BlockPlanks.EnumType type = TreeTypeRegistryModule.getFor(treeType);
            return this.impl$processLogType(blockState, type, treeType);
        }
        if (manipulator instanceof ImmutableLogAxisData) {
            LogAxis logAxis = (LogAxis)((ImmutableLogAxisData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)((BlockLog.EnumAxis)logAxis)));
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.TREE_TYPE)) {
            TreeType treeType = (TreeType)value;
            BlockPlanks.EnumType type = TreeTypeRegistryModule.getFor(treeType);
            return this.impl$processLogType(blockState, type, treeType);
        }
        if (key.equals(Keys.LOG_AXIS)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)((BlockLog.EnumAxis)value)));
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private Optional<BlockState> impl$processLogType(IBlockState blockState, BlockPlanks.EnumType type, TreeType treeType) {
        if (blockState.func_177230_c() instanceof BlockOldLog) {
            if (treeType.equals(TreeTypes.OAK) || treeType.equals(TreeTypes.BIRCH) || treeType.equals(TreeTypes.SPRUCE) || treeType.equals(TreeTypes.JUNGLE)) {
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)type));
            }
        } else if (blockState.func_177230_c() instanceof BlockNewLog && (treeType.equals(TreeTypes.ACACIA) || treeType.equals(TreeTypes.DARK_OAK))) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)type));
        }
        return Optional.empty();
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getTreeData(blockState), (Object)this.getLogAxisData(blockState));
    }
}

