/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import net.minecraft.block.BlockNote;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.Note;
import org.spongepowered.api.data.property.block.InstrumentProperty;
import org.spongepowered.api.data.type.InstrumentType;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.block.BlockMixin;
import org.spongepowered.common.registry.type.NotePitchRegistryModule;

@Mixin(value={BlockNote.class})
public abstract class BlockNoteMixin
extends BlockMixin {
    @Shadow
    protected abstract SoundEvent func_185576_e(int var1);

    @Inject(method={"eventReceived(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;II)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V")}, cancellable=true)
    private void impl$throwNoteBlockSoundEvent(IBlockState state, World worldIn, BlockPos pos, int id, int param, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (!ShouldFire.PLAY_SOUND_EVENT_NOTE_BLOCK) {
            return;
        }
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151579_a) {
            return;
        }
        InstrumentProperty instrumentProperty = ((org.spongepowered.api.world.World)worldIn).getBlock(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()).getProperty(InstrumentProperty.class).orElse(null);
        if (instrumentProperty == null) {
            return;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof Note)) {
            return;
        }
        float pitch = (float)Math.pow(2.0, (double)(param - 12) / 12.0);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            PlaySoundEvent.NoteBlock event = SpongeCommonEventFactory.callPlaySoundNoteBLockEvent(frame.getCurrentCause(), (org.spongepowered.api.world.World)worldIn, (Note)tileEntity, pos, this.func_185576_e(id), (InstrumentType)instrumentProperty.getValue(), NotePitchRegistryModule.getPitch((byte)param), Float.valueOf(pitch));
            if (event.isCancelled()) {
                callbackInfo.setReturnValue(true);
            }
        }
    }
}

