/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableRailDirectionData;
import org.spongepowered.api.data.type.RailDirection;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeRailDirectionData;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={BlockRailBase.class})
public abstract class BlockRailBaseMixin
extends BlockMixin {
    public ImmutableList<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        ImmutableRailDirectionData railDirection = this.impl$getRailDirectionFor(blockState);
        if (railDirection == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)railDirection);
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableRailDirectionData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableRailDirectionData) {
            RailDirection apiDirection = (RailDirection)((ImmutableRailDirectionData)manipulator).type().get();
            BlockRailBase.EnumRailDirection railDirection = (BlockRailBase.EnumRailDirection)apiDirection;
            Optional<BlockState> state = this.impl$getStateForDirection(blockState, railDirection);
            if (state.isPresent()) {
                return state;
            }
            for (Map.Entry entry : blockState.func_177228_b().entrySet()) {
                if (!(entry.getValue() instanceof BlockRailBase.EnumRailDirection) || !((IProperty)entry.getKey()).func_177700_c().contains(railDirection)) continue;
                PropertyEnum property = (PropertyEnum)entry.getKey();
                IBlockState newState = blockState.func_177226_a((IProperty)property, (Comparable)railDirection);
                return Optional.of((BlockState)newState);
            }
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        BlockRailBase.EnumRailDirection railDirection;
        Optional<BlockState> x;
        if (key.equals(Keys.RAIL_DIRECTION) && (x = this.impl$getStateForDirection(blockState, railDirection = (BlockRailBase.EnumRailDirection)value)).isPresent()) {
            return x;
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private Optional<BlockState> impl$getStateForDirection(IBlockState blockState, BlockRailBase.EnumRailDirection railDirection) {
        if (blockState.func_177230_c() instanceof BlockRail) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)railDirection));
        }
        if (blockState.func_177230_c() instanceof BlockRailPowered) {
            if (!BlockRailPowered.field_176568_b.func_177700_c().contains(railDirection)) {
                return Optional.empty();
            }
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRailPowered.field_176568_b, (Comparable)railDirection));
        }
        if (blockState.func_177230_c() instanceof BlockRailDetector) {
            if (!BlockRailDetector.field_176573_b.func_177700_c().contains(railDirection)) {
                return Optional.empty();
            }
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRailDetector.field_176573_b, (Comparable)railDirection));
        }
        return Optional.empty();
    }

    @Nullable
    private ImmutableRailDirectionData impl$getRailDirectionFor(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockRail) {
            return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeRailDirectionData.class, blockState.func_177229_b((IProperty)BlockRail.field_176565_b));
        }
        if (blockState.func_177230_c() instanceof BlockRailPowered) {
            return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeRailDirectionData.class, blockState.func_177229_b((IProperty)BlockRailPowered.field_176568_b));
        }
        if (blockState.func_177230_c() instanceof BlockRailDetector) {
            return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeRailDirectionData.class, blockState.func_177229_b((IProperty)BlockRailDetector.field_176573_b));
        }
        for (Map.Entry entry : blockState.func_177228_b().entrySet()) {
            if (!(entry.getValue() instanceof BlockRailBase.EnumRailDirection)) continue;
            return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeRailDirectionData.class, entry.getValue());
        }
        return null;
    }
}

