/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Game;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.command.ServerCommandManagerBridge;
import org.spongepowered.common.command.MinecraftCommandWrapper;
import org.spongepowered.common.command.SpongeCommandManager;
import org.spongepowered.common.command.WrapperCommandSource;
import org.spongepowered.common.config.category.PhaseTrackerCategory;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.util.VecHelper;

@NonnullByDefault
@Mixin(value={ServerCommandManager.class})
public abstract class ServerCommandManagerMixin
extends CommandHandler
implements ServerCommandManagerBridge {
    private List<MinecraftCommandWrapper> impl$lowPriorityCommands = Lists.newArrayList();
    private List<MinecraftCommandWrapper> impl$earlyRegisterCommands = Lists.newArrayList();
    private static final CopyOnWriteArrayList<String> ASYNC_MOD_COMMAND_EXECUTORS = new CopyOnWriteArrayList();

    @Redirect(method={"notifyListener"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;getGameRules()Lnet/minecraft/world/GameRules;"))
    private GameRules impl$useSenderWorldGamerules(WorldServer overworld, ICommandSender sender, ICommand command, int flags, String translationKey, Object ... translationArgs) {
        return sender.func_130014_f_().func_82736_K();
    }

    public int func_71556_a(ICommandSender sender, String command) {
        if ((command = command.trim()).startsWith("/")) {
            command = command.substring(1);
        }
        String cleanedCommand = command;
        if (!SpongeImplHooks.isMainThread()) {
            PhaseTrackerCategory trackerConfig = SpongeImpl.getGlobalConfigAdapter().getConfig().getPhaseTracker();
            PluginContainer activeModContainer = SpongeImplHooks.getActiveModContainer();
            String id = activeModContainer.getId();
            if (!trackerConfig.resyncCommandsAsync()) {
                if (trackerConfig.isVerbose()) {
                    new PrettyPrinter(60).add("Async Command Execution Warning").centre().hr().add("A plugin/mod attempted to perform a command asynchronously").add().add("Performing the command asynchronously and resycing it\nis disabled in Sponge's main configuration, therefor the command\nwill be ignored. To enable re-submitting the command on the main\nthread, please enable \"resync-commands-from-async\" in the global\nconfig.").add().add("Details of the command:").add("%s : %s", "Command", command).add("%s : %s", "Offending Mod", id).add("%s : %s", "Sender", sender.func_145748_c_() == null ? "null" : sender.func_145748_c_().func_150260_c()).add("Stacktrace").add(new Exception("Async Command Executor")).trace(SpongeImpl.getLogger(), Level.WARN);
                }
                return 0;
            }
            if (!ASYNC_MOD_COMMAND_EXECUTORS.contains(id)) {
                ASYNC_MOD_COMMAND_EXECUTORS.add(id);
                if (trackerConfig.isVerbose()) {
                    new PrettyPrinter(60).add("Async Command Execution Warning").centre().hr().add("A plugin/mod attempted to perform a command asynchronously").add().add("Performing the command asynchronously and resycing it\nis enabled, so Sponge will resync the execution of the\ncommand on the main thread. Some cases where a mod is\nexpecting the command to be run asynchronously to\nmodify other objects may cause issues in said mod.").add().add("Details of the command:").add("%s : %s", "Command", command).add("%s : %s", "Offending Mod", id).add("%s : %s", "Sender", sender == null || sender.func_145748_c_() == null ? "null" : sender.func_145748_c_().func_150260_c()).add("Stacktrace").add(new Exception("Async Command Executor")).trace(SpongeImpl.getLogger(), Level.WARN);
                }
            }
            Task.builder().name("Sponge Async to Sync Command Executor").execute(() -> this.func_71556_a(sender, cleanedCommand)).submit(activeModContainer);
            return 0;
        }
        CommandSource source = WrapperCommandSource.of(sender);
        CommandResult result = SpongeImpl.getGame().getCommandManager().process(source, cleanedCommand);
        result.getAffectedBlocks().ifPresent(integer4 -> sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, integer4.intValue()));
        result.getAffectedEntities().ifPresent(integer3 -> sender.func_174794_a(CommandResultStats.Type.AFFECTED_ENTITIES, integer3.intValue()));
        result.getAffectedItems().ifPresent(integer2 -> sender.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, integer2.intValue()));
        result.getQueryResult().ifPresent(integer1 -> sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, integer1.intValue()));
        result.getSuccessCount().ifPresent(integer -> sender.func_174794_a(CommandResultStats.Type.SUCCESS_COUNT, integer.intValue()));
        return result.getSuccessCount().orElse(0);
    }

    public ICommand func_71560_a(ICommand command) {
        MinecraftCommandWrapper cmd = this.bridge$wrapCommand(command);
        if ("minecraft".equalsIgnoreCase(cmd.getOwner().getId())) {
            this.impl$lowPriorityCommands.add(cmd);
        } else if (!SpongeImpl.isInitialized()) {
            this.impl$earlyRegisterCommands.add(cmd);
        } else {
            SpongeImpl.getGame().getCommandManager().register((Object)cmd.getOwner(), (CommandCallable)cmd, cmd.getNames());
            this.registerDefaultPermissions(SpongeImpl.getGame(), cmd);
        }
        return super.func_71560_a(command);
    }

    @Override
    public MinecraftCommandWrapper bridge$wrapCommand(ICommand command) {
        return new MinecraftCommandWrapper(SpongeImpl.getMinecraftPlugin(), command);
    }

    private void registerDefaultPermissions(Game game, MinecraftCommandWrapper cmd) {
        Optional<PermissionService> perms = game.getServiceManager().provide(PermissionService.class);
        if (perms.isPresent()) {
            PermissionService service = perms.get();
            int opLevel = cmd.getPermissionLevel();
            if (opLevel == -1) {
                return;
            }
            if (service instanceof SpongePermissionService) {
                ((SpongePermissionService)service).getGroupForOpLevel(opLevel).getTransientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, cmd.getCommandPermission(), Tristate.TRUE);
            } else if (opLevel == 0) {
                service.getDefaults().getTransientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, cmd.getCommandPermission(), Tristate.TRUE);
            }
        }
    }

    private void registerCommandsList(List<MinecraftCommandWrapper> cmds, Game game) {
        Iterator<MinecraftCommandWrapper> it = cmds.iterator();
        while (it.hasNext()) {
            MinecraftCommandWrapper cmd = it.next();
            it.remove();
            game.getCommandManager().register((Object)cmd.getOwner(), (CommandCallable)cmd, cmd.getNames());
            this.registerDefaultPermissions(game, cmd);
        }
    }

    @Override
    public void bridge$registerLowPriorityCommands(Game game) {
        this.registerCommandsList(this.impl$lowPriorityCommands, game);
    }

    @Override
    public void bridge$registerEarlyCommands(Game game) {
        this.registerCommandsList(this.impl$earlyRegisterCommands, game);
    }

    public List<String> func_180524_a(ICommandSender sender, String input, @Nullable BlockPos pos) {
        Location<World> targetPos = null;
        if (pos != null) {
            targetPos = new Location<World>((World)sender.func_130014_f_(), VecHelper.toVector3i(pos));
        }
        return ((SpongeCommandManager)SpongeImpl.getGame().getCommandManager()).getSuggestions((CommandSource)sender, input, targetPos, false);
    }
}

