/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import java.util.Collection;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.entity.living.human.EntityHuman;
import org.spongepowered.common.mixin.core.network.datasync.EntityDataManagerAccessor;
import org.spongepowered.common.network.SpoofedEntityDataManager;

@Mixin(value={EntityTrackerEntry.class})
public abstract class EntityTrackerEntryMixin {
    @Shadow
    @Final
    private Entity field_73132_a;
    @Shadow
    @Final
    public Set<EntityPlayerMP> field_73134_o;

    @Shadow
    public abstract void func_151261_b(Packet<?> var1);

    @Redirect(method={"updatePlayerEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/NetHandlerPlayServer;sendPacket(Lnet/minecraft/network/Packet;)V", ordinal=0))
    public void onSendSpawnPacket(NetHandlerPlayServer thisCtx, Packet<?> spawnPacket, EntityPlayerMP playerIn) {
        if (!(this.field_73132_a instanceof EntityHuman)) {
            thisCtx.func_147359_a(spawnPacket);
            return;
        }
        EntityHuman human = (EntityHuman)this.field_73132_a;
        thisCtx.func_147359_a((Packet)human.createPlayerListPacket(SPacketPlayerListItem.Action.ADD_PLAYER));
        thisCtx.func_147359_a(spawnPacket);
        SPacketPlayerListItem removePacket = human.createPlayerListPacket(SPacketPlayerListItem.Action.REMOVE_PLAYER);
        if (human.canRemoveFromListImmediately()) {
            thisCtx.func_147359_a((Packet)removePacket);
        } else {
            human.removeFromTabListDelayed(playerIn, removePacket);
        }
    }

    @Redirect(method={"updatePlayerList"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityTrackerEntry;sendPacketToTrackedPlayers(Lnet/minecraft/network/Packet;)V", ordinal=0))
    public void onSendPassengerPacket(EntityTrackerEntry entityTrackerEntry, Packet<?> packet) {
        entityTrackerEntry.func_151261_b(packet);
    }

    @Inject(method={"createSpawnPacket"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetSpawnPacket(CallbackInfoReturnable<Packet<?>> cir) {
        if (this.field_73132_a instanceof EntityHuman) {
            cir.setReturnValue((Packet<?>)((EntityHuman)this.field_73132_a).createSpawnPacket());
        }
    }

    @Inject(method={"sendMetadata"}, at={@At(value="HEAD")})
    public void onSendMetadata(CallbackInfo ci) {
        if (!(this.field_73132_a instanceof EntityHuman)) {
            return;
        }
        EntityHuman human = (EntityHuman)this.field_73132_a;
        Packet<?>[] packets = human.popQueuedPackets(null);
        for (EntityPlayerMP player : this.field_73134_o) {
            Packet<?>[] playerPackets;
            if (packets != null) {
                for (Packet<?> packet : packets) {
                    player.field_71135_a.func_147359_a(packet);
                }
            }
            if ((playerPackets = human.popQueuedPackets(player)) == null) continue;
            for (Packet<?> packet : playerPackets) {
                player.field_71135_a.func_147359_a(packet);
            }
        }
    }

    @Inject(method={"isVisibleTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void onVisibilityCheck(EntityPlayerMP entityPlayerMP, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (((VanishableBridge)this.field_73132_a).bridge$isVanished()) {
            callbackInfoReturnable.setReturnValue(false);
        }
    }

    @Inject(method={"sendPacketToTrackedPlayers"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkIfTrackedIsInvisiblePriorToSendingPacketToPlayers(Packet<?> packet, CallbackInfo callBackInfo) {
        if (((VanishableBridge)this.field_73132_a).bridge$isVanished()) {
            callBackInfo.cancel();
        }
    }

    @ModifyArg(method={"sendMetadata"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/server/SPacketEntityProperties;<init>(ILjava/util/Collection;)V"))
    private Collection<IAttributeInstance> spongeInjectHealth(Collection<IAttributeInstance> set) {
        if (this.field_73132_a instanceof EntityPlayerMP && ((EntityPlayerMPBridge)this.field_73132_a).bridge$isHealthScaled()) {
            ((EntityPlayerMPBridge)this.field_73132_a).bridge$injectScaledHealth(set);
        }
        return set;
    }

    @ModifyArg(method={"sendMetadata"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/server/SPacketEntityMetadata;<init>(ILnet/minecraft/network/datasync/EntityDataManager;Z)V"))
    private EntityDataManager spongeRelocateDataManager(EntityDataManager manager) {
        Entity player = ((EntityDataManagerAccessor)manager).accessor$getEntity();
        if (player instanceof EntityPlayerMPBridge && ((EntityPlayerMPBridge)player).bridge$isHealthScaled()) {
            return new SpoofedEntityDataManager(manager, player);
        }
        return manager;
    }

    @ModifyArg(method={"updatePlayerEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/server/SPacketEntityProperties;<init>(ILjava/util/Collection;)V"))
    private Collection<IAttributeInstance> spongeInjectHealthForUpdate(Collection<IAttributeInstance> set) {
        if (this.field_73132_a instanceof EntityPlayerMP && ((EntityPlayerMPBridge)this.field_73132_a).bridge$isHealthScaled()) {
            ((EntityPlayerMPBridge)this.field_73132_a).bridge$injectScaledHealth(set);
        }
        return set;
    }
}

