/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.effect;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.mixin.core.entity.EntityMixin;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={EntityLightningBolt.class})
public abstract class EntityLightningBoltMixin
extends EntityMixin {
    private final List<org.spongepowered.api.entity.Entity> struckEntities = Lists.newArrayList();
    private final List<Transaction<BlockSnapshot>> struckBlocks = Lists.newArrayList();
    private boolean effect = false;

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"))
    private boolean spongeImpl$throwEventForChangingBlocks(World world, BlockPos pos, IBlockState blockState) {
        return this.spongeImpl$strikeBlockAndAddSnapshot(world, pos, blockState);
    }

    @Redirect(method={"onUpdate()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"))
    private boolean spongeImpl$throwEventForChangingBlockDuringUpdate(World world, BlockPos pos, IBlockState blockState) {
        return this.spongeImpl$strikeBlockAndAddSnapshot(world, pos, blockState);
    }

    private boolean spongeImpl$strikeBlockAndAddSnapshot(World world, BlockPos pos, IBlockState blockState) {
        if (!this.effect && ((org.spongepowered.api.world.World)world).containsBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            Vector3i pos3i = VecHelper.toVector3i(pos);
            Transaction<SpongeBlockSnapshot> transaction = new Transaction<SpongeBlockSnapshot>(SpongeBlockSnapshotBuilder.pooled().blockState(world.func_180495_p(pos)).world(((org.spongepowered.api.world.World)world).getProperties()).position(pos3i).build(), SpongeBlockSnapshotBuilder.pooled().blockState(blockState).world(((org.spongepowered.api.world.World)world).getProperties()).position(pos3i).build());
            if (!this.struckBlocks.contains(transaction)) {
                this.struckBlocks.add(transaction);
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"onUpdate()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;onStruckByLightning(Lnet/minecraft/entity/effect/EntityLightningBolt;)V"))
    private void spongeImpl$AddEntityToListForEvent(Entity mcEntity, EntityLightningBolt lightningBolt) {
        org.spongepowered.api.entity.Entity entity;
        if (!this.effect && !this.struckEntities.contains(entity = (org.spongepowered.api.entity.Entity)mcEntity)) {
            this.struckEntities.add(entity);
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/EntityLightningBolt;setDead()V")})
    private void spongeImpl$ThrowEventAndProcess(CallbackInfo ci) {
        if (this.field_70128_L || this.field_70170_p.field_72995_K) {
            return;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            LightningEvent.Strike strike = SpongeEventFactory.createLightningEventStrike(frame.getCurrentCause(), this.struckEntities, this.struckBlocks);
            Sponge.getEventManager().post(strike);
            if (!strike.isCancelled()) {
                for (Transaction<BlockSnapshot> bt : strike.getTransactions()) {
                    if (!bt.isValid()) continue;
                    BlockSnapshot bs = bt.getFinal();
                    this.field_70170_p.func_175656_a(VecHelper.toBlockPos(bs.getLocation().get()), (IBlockState)bs.getState());
                }
                for (org.spongepowered.api.entity.Entity e : strike.getEntities()) {
                    ((Entity)e).func_70077_a((EntityLightningBolt)this);
                }
                SpongeImpl.postEvent(SpongeEventFactory.createLightningEventPost(frame.getCurrentCause()));
            }
        }
    }

    @Override
    public void spongeImpl$readFromSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$readFromSpongeCompound(compound);
        if (compound.func_74764_b("effect")) {
            this.effect = compound.func_74767_n("effect");
        }
    }

    @Override
    public void spongeImpl$writeToSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$writeToSpongeCompound(compound);
        compound.func_74757_a("effect", this.effect);
    }
}

